# NL Generic Functions Organization Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions Organization Profile**

## Resource Profile: NL Generic Functions Organization Profile 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization | *Version*:0.2.0 |
| Draft as of 2025-11-24 | *Computable Name*:NlGfOrganization |

 
The organizational hierarchy and details for healthcare organizations. 

**Usages:**

* Examples for this Profile: [example Care Institution](Organization-3e799075-63a2-4a4c-913d-a91b8198463d.md), [example General Practice](Organization-3f39dca9-a392-4eb3-8366-0c7ff53ab3a9.md), [example Hospital](Organization-4815bbe6-9fea-4875-a16c-a168d63054d4.md), [example General Practice](Organization-4cb35b96-f021-4e15-bf71-d67a6d4bebec.md)...Show 3 more,[Nursing department at Organization 3](Organization-631cf10e-42d6-4165-9907-11e2333d4a85.md),[example Hospital](Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.md)and[example Care Institution](Organization-fcf55b06-f22c-4058-9051-b77368bdd26b.md)
* CapabilityStatements using this Profile: [Administration Directory for Administration Client](CapabilityStatement-nl-gf-admin-directory-admin-client.md), [Administration Directory for Update Client](CapabilityStatement-nl-gf-admin-directory-update-client.md) and [Query Directory for Query Client](CapabilityStatement-nl-gf-query-directory-query-client.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.nl.gf|current/StructureDefinition/nl-gf-organization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-organization.csv), [Excel](StructureDefinition-nl-gf-organization.xlsx), [Schematron](StructureDefinition-nl-gf-organization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-organization",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization",
  "version" : "0.2.0",
  "name" : "NlGfOrganization",
  "title" : "NL Generic Functions Organization Profile",
  "status" : "draft",
  "date" : "2025-11-24T15:07:13+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "The organizational hierarchy and details for healthcare organizations.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "zib-healthcareprovider-v3.4-2020EN",
      "uri" : "https://zibs.nl/wiki/HealthcareProvider-v3.4(2020EN)",
      "name" : "zib HealthcareProvider-v3.4(2020EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/nl-core-HealthcareProvider-Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization",
        "constraint" : [
          {
            "key" : "ura-identifier-or-partof",
            "severity" : "error",
            "human" : "an Organization instance must either have an URA-identifier or must be 'partOf' some other instance that is an nl-gf-organization instance.",
            "expression" : "identifier.where(system='http://fhir.nl/fhir/NamingSystem/ura').exists() or partOf.exists()",
            "source" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
          }
        ]
      },
      {
        "id" : "Organization.implicitRules",
        "path" : "Organization.implicitRules",
        "max" : "0"
      },
      {
        "id" : "Organization.modifierExtension",
        "path" : "Organization.modifierExtension",
        "max" : "0"
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "min" : 1
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "min" : 1
      }
    ]
  }
}

```
