# Localization Service - Local Metadata Register - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Localization Service - Local Metadata Register**

## CapabilityStatement: Localization Service - Local Metadata Register 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-localization-repository-lmr | *Version*:0.2.0 |
| Active as of 2025-08-28 | *Computable Name*: |

 
Dutch profile of the CapabilityStatement for a Localization Service - Local Metadata Register 

 [Raw OpenAPI-Swagger Definition file](nl-gf-localization-repository-lmr.openapi.json) | [Download](nl-gf-localization-repository-lmr.openapi.json) 

## Localization Service - Local Metadata Register

* Implementation Guide Version: 0.2.0 
* FHIR Version: 4.0.1 
* Supported Formats: `application/fhir+xml`, `application/fhir+json`
* Published on: 2025-08-28 
* Published by: Stichting Nuts 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

## FHIR RESTful Capabilities

### Mode: server

### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [Patient](#Patient1-1) |   | **Y** |  |  |  |  |  |  |  |

-------

#### Resource Conformance: SHALL Patient

Core FHIR Resource

[Patient](http://hl7.org/fhir/R4/patient.html)

Reference Policy

Interaction summary

* **SHALL** support `read`.

Documentation
> 

HTTP Method HEAD SHALL be supported to check for the existence of -and access to- a Patient resource, without returning the actual resource.




## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "nl-gf-localization-repository-lmr",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-localization-repository-lmr",
  "version" : "0.2.0",
  "title" : "Localization Service - Local Metadata Register",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-08-28",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "Dutch profile of the CapabilityStatement for a Localization Service - Local Metadata Register",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["application/fhir+xml", "application/fhir+json"],
  "rest" : [
    {
      "mode" : "server",
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Patient",
          "documentation" : "HTTP Method HEAD SHALL be supported to check for the existence of -and access to- a Patient resource, without returning the actual resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        }
      ]
    }
  ]
}

```
