# NL Generic Functions Location Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions Location Profile**

## Resource Profile: NL Generic Functions Location Profile 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-location | *Version*:0.2.0 |
| Draft as of 2025-11-24 | *Computable Name*:NlGfLocation |

 
Physical location details for healthcare services, organizations, and practitioners. 

**Usages:**

* CapabilityStatements using this Profile: [Administration Directory for Administration Client](CapabilityStatement-nl-gf-admin-directory-admin-client.md), [Administration Directory for Update Client](CapabilityStatement-nl-gf-admin-directory-update-client.md) and [Query Directory for Query Client](CapabilityStatement-nl-gf-query-directory-query-client.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.nl.gf|current/StructureDefinition/nl-gf-location)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-location.csv), [Excel](StructureDefinition-nl-gf-location.xlsx), [Schematron](StructureDefinition-nl-gf-location.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-location",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-location",
  "version" : "0.2.0",
  "name" : "NlGfLocation",
  "title" : "NL Generic Functions Location Profile",
  "status" : "draft",
  "date" : "2025-11-24T15:07:13+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "Physical location details for healthcare services, organizations, and practitioners.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "zib-healthcareprovider-v3.4-2020EN",
      "uri" : "https://zibs.nl/wiki/HealthcareProvider-v3.4(2020EN)",
      "name" : "zib HealthcareProvider-v3.4(2020EN)"
    },
    {
      "identity" : "zib-contactinformation-v1.2-2020EN",
      "uri" : "https://zibs.nl/wiki/ContactInformation-v1.2(2020EN)",
      "name" : "zib ContactInformation-v1.2(2020EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Location",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/nl-core-HealthcareProvider",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Location",
        "path" : "Location"
      },
      {
        "id" : "Location.implicitRules",
        "path" : "Location.implicitRules",
        "max" : "0"
      },
      {
        "id" : "Location.modifierExtension",
        "path" : "Location.modifierExtension",
        "max" : "0"
      },
      {
        "id" : "Location.status",
        "path" : "Location.status",
        "min" : 1
      },
      {
        "id" : "Location.name",
        "path" : "Location.name",
        "min" : 1
      },
      {
        "id" : "Location.type",
        "path" : "Location.type",
        "min" : 1
      },
      {
        "id" : "Location.managingOrganization",
        "path" : "Location.managingOrganization",
        "min" : 1
      }
    ]
  }
}

```
