# NL Generic Functions HealthcareService Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions HealthcareService Profile**

## Resource Profile: NL Generic Functions HealthcareService Profile 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice | *Version*:0.2.0 |
| Draft as of 2025-11-24 | *Computable Name*:NlGfHealthcareService |

 
The technical details of a healthcare service that can be used in referrals, requests and orders 

**Usages:**

* Examples for this Profile: [Urologie](HealthcareService-08013141-16b2-42a0-8c9a-af57cee5511b.md), [Geriatrie](HealthcareService-120325af-083c-40ee-b16e-01230fe65655.md), [Geriatrie](HealthcareService-4fcf98c7-b198-4d61-8b3e-5ea39e33c405.md), [Polikliniek 't Vaatje](HealthcareService-5cb05355-474b-4d30-8b0e-a9ca574b8274.md)...Show 4 more,[Orthopedie](HealthcareService-9d47ca45-4166-4531-a23d-ef5fa613ece4.md),[Verpleging](HealthcareService-b48826dc-2d58-479a-bfd3-80b7a9d69757.md),[Neurochirurgie](HealthcareService-c79125e5-739f-4238-959c-cd5872518c1f.md)and[Interne Geneeskunde](HealthcareService-f6a508bd-9455-4afa-aad0-baec0833602d.md)
* CapabilityStatements using this Profile: [Administration Directory for Administration Client](CapabilityStatement-nl-gf-admin-directory-admin-client.md), [Administration Directory for Update Client](CapabilityStatement-nl-gf-admin-directory-update-client.md) and [Query Directory for Query Client](CapabilityStatement-nl-gf-query-directory-query-client.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.nl.gf|current/StructureDefinition/nl-gf-healthcareservice)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-healthcareservice.csv), [Excel](StructureDefinition-nl-gf-healthcareservice.xlsx), [Schematron](StructureDefinition-nl-gf-healthcareservice.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-healthcareservice",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice",
  "version" : "0.2.0",
  "name" : "NlGfHealthcareService",
  "title" : "NL Generic Functions HealthcareService Profile",
  "status" : "draft",
  "date" : "2025-11-24T15:07:13+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "The technical details of a healthcare service that can be used in referrals, requests and orders",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "HealthcareService",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/HealthcareService",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "HealthcareService",
        "path" : "HealthcareService"
      },
      {
        "id" : "HealthcareService.implicitRules",
        "path" : "HealthcareService.implicitRules",
        "max" : "0"
      },
      {
        "id" : "HealthcareService.modifierExtension",
        "path" : "HealthcareService.modifierExtension",
        "max" : "0"
      },
      {
        "id" : "HealthcareService.providedBy",
        "path" : "HealthcareService.providedBy",
        "min" : 1
      },
      {
        "id" : "HealthcareService.type",
        "path" : "HealthcareService.type",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://decor.nictiz.nl/fhir/ValueSet/2.16.840.1.113883.2.4.3.11.60.121.11.19--20200901000000"
        }
      },
      {
        "id" : "HealthcareService.type.extension:supportedActivityDefinitions",
        "path" : "HealthcareService.type.extension",
        "sliceName" : "supportedActivityDefinitions",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/supported-activity-definitions"
            ]
          }
        ]
      },
      {
        "id" : "HealthcareService.specialty",
        "path" : "HealthcareService.specialty",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://decor.nictiz.nl/fhir/ValueSet/2.16.840.1.113883.2.4.3.11.60.121.11.22--20200901000000"
        }
      },
      {
        "id" : "HealthcareService.name",
        "path" : "HealthcareService.name",
        "min" : 1
      }
    ]
  }
}

```
