# fhir.nl.gf#0.3.0: Netherlands - Generic Functions for data exchange Implementation Guide

## Pages

* [Home](index.md)
* [Request Revocation status [GFI-003]](GFI-003.md)
* [Routing](routing.md)
* [Request key material [GFI-001]](GFI-001.md)
* [Authentication](authentication.md)
* [Identification](identification.md)
* [Credential Catalog](credential-catalog.md)
* [Authenticated Interaction [GFI-005]](GFI-005.md)
* [History](history.md)
* [Issue Claims [GFI-002]](GFI-002.md)
* [Request Access Token [GFI-004]](GFI-004.md)
* [Localization](localization.md)
* [Care Services Directory](care-services.md)
* [Artifacts Summary](artifacts.md)
* [Authorization](authorization.md)
* [Token introspection [GFI-006]](GFI-006.md)
* [Consent](consent.md)

## Resources

### CodeSystems

* [NL GF Data exchange capabilities](CodeSystem-nl-gf-data-exchange-capabilities.md)
* [NL GF WLZ Zorgprofielen CodeSystem](CodeSystem-nl-gf-wlz-zorgprofielen-cs.md)

### ValueSets

* [NL GF Data exchange capabilities](ValueSet-nl-gf-data-exchange-capabilities-vs.md)
* [NL GF WLZ Zorgprofielen ValueSet](ValueSet-nl-gf-wlz-zorgprofielen-vs.md)

### Resource Profiles

* [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)
* [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)
* [NL Generic Functions Localization DocumentReference Profile](StructureDefinition-nl-gf-localization-documentreference.md)
* [NL Generic Functions Location Profile](StructureDefinition-nl-gf-location.md)
* [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization-lrza.md)
* [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)
* [NL Generic Functions OrganizationAffiliation Profile](StructureDefinition-nl-gf-organizationaffiliation.md)
* [NL Generic Functions Practitioner Profile](StructureDefinition-nl-gf-practitioner.md)
* [NL Generic Functions PractitionerRole Profile](StructureDefinition-nl-gf-practitionerrole.md)
* [NL Generic Functions Task Profile for FHIR STU3](StructureDefinition-nl-gf-task-stu3.md)

### Extensions

* [Supported ActivityDefinitions and PlanDefinitions by HealthcareServices](StructureDefinition-supported-activity-definitions.md)
* [HealthcareService for Task in STU3](StructureDefinition-task-stu3-healthcareservice.md)
* [Location for Task in STU3](StructureDefinition-task-stu3-location.md)

### CapabilityStatements

* [Administration Directory for Administration Client](CapabilityStatement-nl-gf-admin-directory-admin-client.md)
* [Administration Directory for Update Client](CapabilityStatement-nl-gf-admin-directory-update-client.md)
* [Localization Service - Local Metadata Register](CapabilityStatement-nl-gf-localization-repository-lmr.md)
* [Localization Service](CapabilityStatement-nl-gf-localization-repository.md)
* [Query Directory for Query Client for only Read operations](CapabilityStatement-nl-gf-query-directory-query-client-reads.md)
* [Query Directory for Query Client](CapabilityStatement-nl-gf-query-directory-query-client.md)

### ImplementationGuides

* [Netherlands - Generic Functions for data exchange Implementation Guide](index.md)

### NamingSystems

* [Pseudonymized BSN](NamingSystem-pseudo-bsn.md)

### Examples

* [admin-directory-lrza (Bundle)](Bundle-admin-directory-lrza.md)
* [admin-directory-org1 (Bundle)](Bundle-admin-directory-org1.md)
* [admin-directory-org2 (Bundle)](Bundle-admin-directory-org2.md)
* [admin-directory-org3 (Bundle)](Bundle-admin-directory-org3.md)
* [phi-org1 (Bundle)](Bundle-phi-org1.md)
* [phi-org2 (Bundle)](Bundle-phi-org2.md)
* [phi-org3 (Bundle)](Bundle-phi-org3.md)
* [query-directory (Bundle)](Bundle-query-directory.md)
* [5a7f34e7-9b7b-4e5c-ba7c-890edbc4d757 (Condition)](Condition-5a7f34e7-9b7b-4e5c-ba7c-890edbc4d757.md)
* [52b792ba-11ae-42f3-bcc1-231f333f2317 (DocumentReference)](DocumentReference-52b792ba-11ae-42f3-bcc1-231f333f2317.md)
* [FHIR STU3 Endpoint (Endpoint)](Endpoint-2427ca0c-8a29-4a6a-aabd-50cf02f587a7.md)
* [FHIR Endpoint 2 (Endpoint)](Endpoint-430f7379-8ec2-4e55-b096-919995da61e2.md)
* [FHIR Endpoint 3 (Endpoint)](Endpoint-553416dd-da12-40f7-a9bd-eb3e193177bd.md)
* [FHIR Endpoint 1 (Endpoint)](Endpoint-59654248-477c-4694-b156-e0042f0765a6.md)
* [FHIR STU3 Endpoint (Endpoint)](Endpoint-72a349cc-7336-4a91-873d-fc9349769e1a.md)
* [FHIR R4 Endpoint (Endpoint)](Endpoint-8f224548-6d50-44b6-82c5-75826ee0900f.md)
* [FHIR Endpoint 2 (Endpoint)](Endpoint-960a4f8c-74d8-482c-97ab-e2a025869fee.md)
* [FHIR Endpoint 1 (Endpoint)](Endpoint-ad1-e1.md)
* [FHIR Endpoint 2 (Endpoint)](Endpoint-ad2-e1.md)
* [DICOM-WADO-RS Endpoint (Endpoint)](Endpoint-ad2-e2.md)
* [FHIR STU3 Endpoint (Endpoint)](Endpoint-ad2-e3.md)
* [FHIR R4 Endpoint (Endpoint)](Endpoint-ad3-e1.md)
* [FHIR STU3 Endpoint (Endpoint)](Endpoint-ad3-e2.md)
* [DICOM-WADO-RS Endpoint (Endpoint)](Endpoint-d4c1d657-67a9-471c-9732-9c042e9a6d43.md)
* [FHIR Endpoint 1 (Endpoint)](Endpoint-ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4.md)
* [FHIR Endpoint 1 (Endpoint)](Endpoint-lrza-e1.md)
* [FHIR Endpoint 2 (Endpoint)](Endpoint-lrza-e2.md)
* [FHIR Endpoint 3 (Endpoint)](Endpoint-lrza-e3.md)
* [Urologie (HealthcareService)](HealthcareService-08013141-16b2-42a0-8c9a-af57cee5511b.md)
* [Geriatrie (HealthcareService)](HealthcareService-120325af-083c-40ee-b16e-01230fe65655.md)
* [Geriatrie (HealthcareService)](HealthcareService-4fcf98c7-b198-4d61-8b3e-5ea39e33c405.md)
* [Polikliniek 't Vaatje (HealthcareService)](HealthcareService-5cb05355-474b-4d30-8b0e-a9ca574b8274.md)
* [Orthopedie (HealthcareService)](HealthcareService-9d47ca45-4166-4531-a23d-ef5fa613ece4.md)
* [Polikliniek 't Vaatje (HealthcareService)](HealthcareService-ad2-hs1.md)
* [Neurochirurgie (HealthcareService)](HealthcareService-ad2-hs2.md)
* [Orthopedie (HealthcareService)](HealthcareService-ad2-hs3.md)
* [Interne Geneeskunde (HealthcareService)](HealthcareService-ad2-hs4.md)
* [Geriatrie (HealthcareService)](HealthcareService-ad2-hs5.md)
* [Urologie (HealthcareService)](HealthcareService-ad2-hs6.md)
* [Geriatrie (HealthcareService)](HealthcareService-ad3-hs1.md)
* [Verpleging (HealthcareService)](HealthcareService-ad3-hs2.md)
* [Verpleging (HealthcareService)](HealthcareService-b48826dc-2d58-479a-bfd3-80b7a9d69757.md)
* [Neurochirurgie (HealthcareService)](HealthcareService-c79125e5-739f-4238-959c-cd5872518c1f.md)
* [Interne Geneeskunde (HealthcareService)](HealthcareService-f6a508bd-9455-4afa-aad0-baec0833602d.md)
* [Main Building (Location)](Location-7c5e3d2a-1f9e-4b8c-9d6a-8e2f5c3b1a4d.md)
* [Verpleeghuis Weltevree (Location)](Location-9a2b8f1c-4e7d-42a1-b3c9-2d5e8f7a6c1b.md)
* [Main Building (Location)](Location-ad3-l1.md)
* [Verpleeghuis Weltevree (Location)](Location-ad3-l2.md)
* [example Care Institution (Organization)](Organization-3e799075-63a2-4a4c-913d-a91b8198463d.md)
* [example General Practice (Organization)](Organization-3f39dca9-a392-4eb3-8366-0c7ff53ab3a9.md)
* [example Hospital (Organization)](Organization-4815bbe6-9fea-4875-a16c-a168d63054d4.md)
* [example General Practice (Organization)](Organization-4cb35b96-f021-4e15-bf71-d67a6d4bebec.md)
* [Nursing department at Organization 3 (Organization)](Organization-631cf10e-42d6-4165-9907-11e2333d4a85.md)
* [example General Practice (Organization)](Organization-ad1-o1.md)
* [example Hospital (Organization)](Organization-ad2-o1.md)
* [example Care Institution (Organization)](Organization-ad3-o1.md)
* [Nursing department at Organization 3 (Organization)](Organization-ad3-o2.md)
* [example Hospital (Organization)](Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.md)
* [example Care Institution (Organization)](Organization-fcf55b06-f22c-4058-9051-b77368bdd26b.md)
* [example General Practice (Organization)](Organization-lrza-o1.md)
* [example Hospital (Organization)](Organization-lrza-o2.md)
* [example Care Institution (Organization)](Organization-lrza-o3.md)
* [27e58ece-409e-44f9-8cc1-b33495a0ef9d (Patient)](Patient-27e58ece-409e-44f9-8cc1-b33495a0ef9d.md)
* [040b160a-6072-4244-adc0-2b786c4ef052 (Practitioner)](Practitioner-040b160a-6072-4244-adc0-2b786c4ef052.md)
* [08630c28-5e2a-4b0c-b8ce-f08f533246b9 (Practitioner)](Practitioner-08630c28-5e2a-4b0c-b8ce-f08f533246b9.md)
* [9a63e407-34af-4ae4-ad3c-f7107fbbc0cd (Practitioner)](Practitioner-9a63e407-34af-4ae4-ad3c-f7107fbbc0cd.md)
* [ad1-p1 (Practitioner)](Practitioner-ad1-p1.md)
* [ad2-p1 (Practitioner)](Practitioner-ad2-p1.md)
* [ad3-p1 (Practitioner)](Practitioner-ad3-p1.md)
* [5fa4c91a-a12f-48ae-a4c7-92971dc7ab53 (PractitionerRole)](PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.md)
* [ad1-pr1 (PractitionerRole)](PractitionerRole-ad1-pr1.md)
* [ad2-pr1 (PractitionerRole)](PractitionerRole-ad2-pr1.md)
* [ad3-pr1 (PractitionerRole)](PractitionerRole-ad3-pr1.md)
* [d60525bd-5caf-4437-8f4b-4156300a27de (PractitionerRole)](PractitionerRole-d60525bd-5caf-4437-8f4b-4156300a27de.md)
* [f051d3bd-26ff-4030-a5b6-fc4ef2be83ba (PractitionerRole)](PractitionerRole-f051d3bd-26ff-4030-a5b6-fc4ef2be83ba.md)
* [53a41e63-e826-45fa-9076-9be4b18399c8 (ServiceRequest)](ServiceRequest-53a41e63-e826-45fa-9076-9be4b18399c8.md)
* [a0fc5221-bcd9-46f1-922f-c2913dae5d63 (Task)](Task-a0fc5221-bcd9-46f1-922f-c2913dae5d63.md)
