# Bundle of personal health information in ECD of Organization 3 - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle of personal health information in ECD of Organization 3**

## Example Bundle: Bundle of personal health information in ECD of Organization 3



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "phi-org3",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:96e7aa36-6d66-4a9e-bf6b-245d97d8ec1d",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "96e7aa36-6d66-4a9e-bf6b-245d97d8ec1d",
        "meta" : {
          "profile" : ["http://nictiz.nl/fhir/StructureDefinition/nl-core-Patient"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_96e7aa36-6d66-4a9e-bf6b-245d97d8ec1d\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient 96e7aa36-6d66-4a9e-bf6b-245d97d8ec1d</b></p><a name=\"96e7aa36-6d66-4a9e-bf6b-245d97d8ec1d\"> </a><a name=\"hc96e7aa36-6d66-4a9e-bf6b-245d97d8ec1d\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Patient\">nl core Patient</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Jaantje Merkens  Female, DoB: 1950-02-26 ( http://organization3.example.org/EHR/patients#126)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Other Ids (see the one above)\">Other Ids:</td><td colspan=\"3\"><ul><li><code>http://fhir.nl/fhir/NamingSystem/bsn</code>/111222333</li><li><code>https://cp3-test.example.org/Patient</code>/96e7aa36-6d66-4a9e-bf6b-245d97d8ec1d</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><ul><li><a href=\"tel:+31612345678\">+31612345678</a></li><li><a href=\"mailto:j.merkens@bigtech.com\">j.merkens@bigtech.com</a></li><li>Kerkstraat 18 Ulft 7071 WZ </li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Patient Links\">Links:</td><td colspan=\"3\"><ul><li>Managing Organization: <a href=\"Organization-3e799075-63a2-4a4c-913d-a91b8198463d.html\">Organization 1</a></li></ul></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://organization3.example.org/EHR/patients",
            "value" : "126"
          },
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/bsn",
            "value" : "111222333"
          },
          {
            "system" : "https://cp3-test.example.org/Patient",
            "value" : "96e7aa36-6d66-4a9e-bf6b-245d97d8ec1d",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "33333333"
              }
            }
          }
        ],
        "name" : [
          {
            "family" : "Merkens",
            "given" : ["Jaantje"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31612345678"
          },
          {
            "system" : "email",
            "value" : "j.merkens@bigtech.com"
          }
        ],
        "gender" : "female",
        "birthDate" : "1950-02-26",
        "address" : [
          {
            "line" : ["Kerkstraat 18"],
            "city" : "Ulft",
            "postalCode" : "7071 WZ"
          }
        ],
        "managingOrganization" : {
          "reference" : "Organization/3e799075-63a2-4a4c-913d-a91b8198463d",
          "display" : "Organization 1"
        }
      },
      "request" : {
        "method" : "PUT",
        "url" : "Patient/96e7aa36-6d66-4a9e-bf6b-245d97d8ec1d"
      }
    },
    {
      "fullUrl" : "urn:uuid:8732d369-7759-447b-af01-f3e0c601b452",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "8732d369-7759-447b-af01-f3e0c601b452",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_8732d369-7759-447b-af01-f3e0c601b452\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 8732d369-7759-447b-af01-f3e0c601b452</b></p><a name=\"8732d369-7759-447b-af01-f3e0c601b452\"> </a><a name=\"hc8732d369-7759-447b-af01-f3e0c601b452\"> </a><p><b>identifier</b>: <code>https://cp3-test.example.org/MedicationStatement</code>/8732d369-7759-447b-af01-f3e0c601b452</p><p><b>status</b>: Active</p><p><b>medication</b>: <span title=\"Codes:{http://www.whocc.no/atc L04AA32}\">apremilast</span></p><p><b>subject</b>: <a href=\"Bundle-phi-org3.html#Patient_96e7aa36-6d66-4a9e-bf6b-245d97d8ec1d\">Jaantje Merkens  Female, DoB: 1950-02-26 ( http://organization3.example.org/EHR/patients#126)</a></p><p><b>dateAsserted</b>: 2024-10-03</p><p><b>informationSource</b>: <a href=\"PractitionerRole-d60525bd-5caf-4437-8f4b-4156300a27de.html\">PractitionerRole Klinisch geriater</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: 10 mg orally every 4 hours</p><p><b>timing</b>: 6 per 1 day</p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>10 mg</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp3-test.example.org/MedicationStatement",
            "value" : "8732d369-7759-447b-af01-f3e0c601b452",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "33333333"
              }
            }
          }
        ],
        "status" : "active",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "L04AA32",
              "display" : "apremilast"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/96e7aa36-6d66-4a9e-bf6b-245d97d8ec1d"
        },
        "dateAsserted" : "2024-10-03",
        "informationSource" : {
          "reference" : "PractitionerRole/d60525bd-5caf-4437-8f4b-4156300a27de"
        },
        "dosage" : [
          {
            "text" : "10 mg orally every 4 hours",
            "timing" : {
              "repeat" : {
                "frequency" : 6,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 10,
                  "unit" : "mg"
                }
              }
            ]
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "MedicationStatement/8732d369-7759-447b-af01-f3e0c601b452"
      }
    },
    {
      "fullUrl" : "urn:uuid:bd8f360a-7bf2-4b65-9202-f3c092525492",
      "resource" : {
        "resourceType" : "CareTeam",
        "id" : "bd8f360a-7bf2-4b65-9202-f3c092525492",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"CareTeam_bd8f360a-7bf2-4b65-9202-f3c092525492\"> </a><p class=\"res-header-id\"><b>Generated Narrative: CareTeam bd8f360a-7bf2-4b65-9202-f3c092525492</b></p><a name=\"bd8f360a-7bf2-4b65-9202-f3c092525492\"> </a><a name=\"hcbd8f360a-7bf2-4b65-9202-f3c092525492\"> </a><p><b>identifier</b>: <code>https://cp3-test.example.org/CareTeam</code>/bd8f360a-7bf2-4b65-9202-f3c092525492</p><blockquote><p><b>participant</b></p><p><b>member</b>: <a href=\"Bundle-phi-org3.html#Patient_96e7aa36-6d66-4a9e-bf6b-245d97d8ec1d\">Jaantje Merkens  Female, DoB: 1950-02-26 ( http://organization3.example.org/EHR/patients#126)</a></p><p><b>period</b>: 2024-08-27 --&gt; (ongoing)</p></blockquote><blockquote><p><b>participant</b></p><p><b>member</b>: <a href=\"PractitionerRole-d60525bd-5caf-4437-8f4b-4156300a27de.html\">PractitionerRole Klinisch geriater</a></p><p><b>period</b>: 2024-08-27 --&gt; (ongoing)</p></blockquote><blockquote><p><b>participant</b></p><p><b>member</b>: <a href=\"Organization-3e799075-63a2-4a4c-913d-a91b8198463d.html\">Organization example Care Institution</a></p><p><b>period</b>: 2024-08-27 --&gt; (ongoing)</p></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp3-test.example.org/CareTeam",
            "value" : "bd8f360a-7bf2-4b65-9202-f3c092525492",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "33333333"
              }
            }
          }
        ],
        "participant" : [
          {
            "member" : {
              "reference" : "Patient/96e7aa36-6d66-4a9e-bf6b-245d97d8ec1d"
            },
            "period" : {
              "start" : "2024-08-27"
            }
          },
          {
            "member" : {
              "reference" : "PractitionerRole/d60525bd-5caf-4437-8f4b-4156300a27de"
            },
            "period" : {
              "start" : "2024-08-27"
            }
          },
          {
            "member" : {
              "reference" : "Organization/3e799075-63a2-4a4c-913d-a91b8198463d",
              "identifier" : {
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "33333333"
              }
            },
            "period" : {
              "start" : "2024-08-27"
            }
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "CareTeam/bd8f360a-7bf2-4b65-9202-f3c092525492"
      }
    }
  ]
}

```
