# Bundle of care services in EHR of Organization 2 - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle of care services in EHR of Organization 2**

## Example Bundle: Bundle of care services in EHR of Organization 2

Bundle admin-directory-org2 of type transaction

-------

Entry 1 - fullUrl = urn:uuid:cff921f3-c1c1-4a4c-8f0f-cafd0aa25067

Resource Organization:

> 

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/22222222**type**:Ziekenhuis,Hospital**name**: example Hospital
> **contact****telecom**:[+31301234567](tel:+31301234567),[info@cp2.example.org](mailto:info@cp2.example.org)**address**: Catharinastraat 21 Doetinchem 7001 BZ
**endpoint**:
* [Endpoint FHIR Endpoint 2](Endpoint-430f7379-8ec2-4e55-b096-919995da61e2.md)
* [Endpoint DICOM-WADO-RS Endpoint](Endpoint-d4c1d657-67a9-471c-9732-9c042e9a6d43.md)
* [Endpoint FHIR STU3 Endpoint](Endpoint-2427ca0c-8a29-4a6a-aabd-50cf02f587a7.md)

Request:

```
PUT Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067

```

-------

Entry 2 - fullUrl = urn:uuid:430f7379-8ec2-4e55-b096-919995da61e2

Resource Endpoint:

> 

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**status**: Active**connectionType**:HL7 FHIR**name**: FHIR Endpoint 2**managingOrganization**: Identifier:`http://fhir.nl/fhir/NamingSystem/kvk`/08013836**contact**:[+3131599991](tel:+3131599991),[info@nedap.example.org](mailto:info@nedap.example.org)**address**:[https://cp2-test.example.org/fhirr4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4)

Request:

```
PUT Endpoint/430f7379-8ec2-4e55-b096-919995da61e2

```

-------

Entry 3 - fullUrl = urn:uuid:d4c1d657-67a9-471c-9732-9c042e9a6d43

Resource Endpoint:

> 

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**status**: Active**connectionType**:DICOM WADO-RS**name**: DICOM-WADO-RS Endpoint**managingOrganization**: Identifier:`http://fhir.nl/fhir/NamingSystem/kvk`/08013836**contact**:[+3131599991](tel:+3131599991),[info@nedap.example.org](mailto:info@nedap.example.org)**address**:[https://cp2-test.example.org/dicom-wado-rs](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/dicom-wado-rs)

Request:

```
PUT Endpoint/d4c1d657-67a9-471c-9732-9c042e9a6d43

```

-------

Entry 4 - fullUrl = urn:uuid:2427ca0c-8a29-4a6a-aabd-50cf02f587a7

Resource Endpoint:

> 

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**status**: Active**connectionType**:HL7 FHIR**name**: FHIR STU3 Endpoint**managingOrganization**: Identifier:`http://fhir.nl/fhir/NamingSystem/kvk`/08013836**contact**:[+3131599991](tel:+3131599991),[info@nedap.example.org](mailto:info@nedap.example.org)**address**:[https://cp2-test.example.org/fhirstu3](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirstu3)

Request:

```
PUT Endpoint/2427ca0c-8a29-4a6a-aabd-50cf02f587a7

```

-------

Entry 5 - fullUrl = urn:uuid:5cb05355-474b-4d30-8b0e-a9ca574b8274

Resource HealthcareService:

> 

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**active**: true**providedBy**:[Organization example Hospital](Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.md)**type**:Consultation**specialty**:Chirurgie (Heelkunde),Chirurg**name**: Polikliniek 't Vaatje

Request:

```
PUT HealthcareService/5cb05355-474b-4d30-8b0e-a9ca574b8274

```

-------

Entry 6 - fullUrl = urn:uuid:c79125e5-739f-4238-959c-cd5872518c1f

Resource HealthcareService:

> 

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**active**: true**providedBy**:[Organization example Hospital](Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.md)**type**:Consultation**specialty**:Medisch specialisten, neurochirurgie,Neurochirurg**name**: Neurochirurgie

Request:

```
PUT HealthcareService/c79125e5-739f-4238-959c-cd5872518c1f

```

-------

Entry 7 - fullUrl = urn:uuid:9d47ca45-4166-4531-a23d-ef5fa613ece4

Resource HealthcareService:

> 

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**active**: true**providedBy**:[Organization example Hospital](Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.md)**type**:Consultation**specialty**:Medisch specialisten, orthopedie,Orthopedisch chirurg**name**: Orthopedie

Request:

```
PUT HealthcareService/9d47ca45-4166-4531-a23d-ef5fa613ece4

```

-------

Entry 8 - fullUrl = urn:uuid:f6a508bd-9455-4afa-aad0-baec0833602d

Resource HealthcareService:

> 

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**active**: true**providedBy**:[Organization example Hospital](Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.md)**type**:Consultation**specialty**:Interne geneeskunde,Internist**name**: Interne Geneeskunde

Request:

```
PUT HealthcareService/f6a508bd-9455-4afa-aad0-baec0833602d

```

-------

Entry 9 - fullUrl = urn:uuid:120325af-083c-40ee-b16e-01230fe65655

Resource HealthcareService:

> 

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**active**: true**providedBy**:[Organization example Hospital](Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.md)**type**:Consultation**specialty**:Medisch specialisten, geriatrie,Klinisch geriater**name**: Geriatrie

Request:

```
PUT HealthcareService/120325af-083c-40ee-b16e-01230fe65655

```

-------

Entry 10 - fullUrl = urn:uuid:08013141-16b2-42a0-8c9a-af57cee5511b

Resource HealthcareService:

> 

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**active**: true**providedBy**:[Organization example Hospital](Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.md)**type**:Consultation**specialty**:Medisch specialisten, urologie,Uroloog**name**: Urologie

Request:

```
PUT HealthcareService/08013141-16b2-42a0-8c9a-af57cee5511b

```

-------

Entry 11 - fullUrl = urn:uuid:f051d3bd-26ff-4030-a5b6-fc4ef2be83ba

Resource PractitionerRole:

> 

Profile: [NL Generic Functions PractitionerRole Profile](StructureDefinition-nl-gf-practitionerrole.md)

**identifier**:`http://cp2.example.org/HRM/assignments`/123456**practitioner**:[Practitioner Caroline van Dijk(official)](Practitioner-040b160a-6072-4244-adc0-2b786c4ef052.md)**organization**:[Organization example Hospital](Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.md)**code**:Cardioloog**specialty**:Cardioloog

Request:

```
PUT PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba

```

-------

Entry 12 - fullUrl = urn:uuid:040b160a-6072-4244-adc0-2b786c4ef052

Resource Practitioner:

> 

Profiles: [NL Generic Functions Practitioner Profile](StructureDefinition-nl-gf-practitioner.md), [nl core HealthProfessional Practitioner](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-HealthProfessional-Practitioner)

**identifier**:`http://cp2.example.org/HRM/employees`/1234,`http://fhir.nl/fhir/NamingSystem/uzi`/UZI-1**name**: Caroline van Dijk(Official)

Request:

```
PUT Practitioner/040b160a-6072-4244-adc0-2b786c4ef052

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "admin-directory-org2",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:cff921f3-c1c1-4a4c-8f0f-cafd0aa25067",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "cff921f3-c1c1-4a4c-8f0f-cafd0aa25067",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_cff921f3-c1c1-4a4c-8f0f-cafd0aa25067\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization cff921f3-c1c1-4a4c-8f0f-cafd0aa25067</b></p><a name=\"cff921f3-c1c1-4a4c-8f0f-cafd0aa25067\"> </a><a name=\"hccff921f3-c1c1-4a4c-8f0f-cafd0aa25067\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-organization.html\">NL Generic Functions Organization Profile</a></p></div><p><b>identifier</b>: Ura/22222222</p><p><b>type</b>: <span title=\"Codes:{http://nictiz.nl/fhir/NamingSystem/organization-type V4}\">Ziekenhuis</span>, <span title=\"Codes:{http://snomed.info/sct 22232009}\">Hospital</span></p><p><b>name</b>: example Hospital</p><p><b>telecom</b>: <a href=\"tel:+31301234567\">+31301234567</a>, <a href=\"mailto:info@cp2.example.org\">info@cp2.example.org</a></p><p><b>address</b>: Catharinastraat 21 Doetinchem 7001 BZ </p><p><b>endpoint</b>: </p><ul><li><a href=\"Endpoint-430f7379-8ec2-4e55-b096-919995da61e2.html\">Endpoint FHIR Endpoint 2</a></li><li><a href=\"Endpoint-d4c1d657-67a9-471c-9732-9c042e9a6d43.html\">Endpoint DICOM-WADO-RS Endpoint</a></li><li><a href=\"Endpoint-2427ca0c-8a29-4a6a-aabd-50cf02f587a7.html\">Endpoint FHIR STU3 Endpoint</a></li></ul></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/ura",
            "value" : "22222222"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
                "code" : "V4",
                "display" : "Ziekenhuis"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "22232009",
                "display" : "Hospital"
              }
            ]
          }
        ],
        "name" : "example Hospital",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31301234567",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@cp2.example.org",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["Catharinastraat 21"],
            "_line" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "Catharinastraat"
                  },
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "21"
                  }
                ]
              }
            ],
            "city" : "Doetinchem",
            "postalCode" : "7001 BZ"
          }
        ],
        "endpoint" : [
          {
            "reference" : "Endpoint/430f7379-8ec2-4e55-b096-919995da61e2"
          },
          {
            "reference" : "Endpoint/d4c1d657-67a9-471c-9732-9c042e9a6d43"
          },
          {
            "reference" : "Endpoint/2427ca0c-8a29-4a6a-aabd-50cf02f587a7"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067"
      }
    },
    {
      "fullUrl" : "urn:uuid:430f7379-8ec2-4e55-b096-919995da61e2",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "430f7379-8ec2-4e55-b096-919995da61e2",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_430f7379-8ec2-4e55-b096-919995da61e2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint 430f7379-8ec2-4e55-b096-919995da61e2</b></p><a name=\"430f7379-8ec2-4e55-b096-919995da61e2\"> </a><a name=\"hc430f7379-8ec2-4e55-b096-919995da61e2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type hl7-fhir-rest</a>: HL7 FHIR</p><p><b>name</b>: FHIR Endpoint 2</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/08013836</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@nedap.example.org\">info@nedap.example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client}\">Care Services Directory for Update Client</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4\">https://cp2-test.example.org/fhirr4</a></p></div>"
        },
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR Endpoint 2",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "08013836"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@nedap.example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client",
                "display" : "Care Services Directory for Update Client"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp2-test.example.org/fhirr4"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/430f7379-8ec2-4e55-b096-919995da61e2"
      }
    },
    {
      "fullUrl" : "urn:uuid:d4c1d657-67a9-471c-9732-9c042e9a6d43",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "d4c1d657-67a9-471c-9732-9c042e9a6d43",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_d4c1d657-67a9-471c-9732-9c042e9a6d43\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint d4c1d657-67a9-471c-9732-9c042e9a6d43</b></p><a name=\"d4c1d657-67a9-471c-9732-9c042e9a6d43\"> </a><a name=\"hcd4c1d657-67a9-471c-9732-9c042e9a6d43\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-dicom-wado-rs\">Endpoint Connection Type dicom-wado-rs</a>: DICOM WADO-RS</p><p><b>name</b>: DICOM-WADO-RS Endpoint</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/08013836</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@nedap.example.org\">info@nedap.example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/endpoint-payload-type any}\">Any</span></p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/dicom-wado-rs\">https://cp2-test.example.org/dicom-wado-rs</a></p></div>"
        },
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "dicom-wado-rs"
        },
        "name" : "DICOM-WADO-RS Endpoint",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "08013836"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@nedap.example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/endpoint-payload-type",
                "code" : "any",
                "display" : "Any"
              }
            ]
          }
        ],
        "address" : "https://cp2-test.example.org/dicom-wado-rs"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/d4c1d657-67a9-471c-9732-9c042e9a6d43"
      }
    },
    {
      "fullUrl" : "urn:uuid:2427ca0c-8a29-4a6a-aabd-50cf02f587a7",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "2427ca0c-8a29-4a6a-aabd-50cf02f587a7",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_2427ca0c-8a29-4a6a-aabd-50cf02f587a7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint 2427ca0c-8a29-4a6a-aabd-50cf02f587a7</b></p><a name=\"2427ca0c-8a29-4a6a-aabd-50cf02f587a7\"> </a><a name=\"hc2427ca0c-8a29-4a6a-aabd-50cf02f587a7\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type hl7-fhir-rest</a>: HL7 FHIR</p><p><b>name</b>: FHIR STU3 Endpoint</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/08013836</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@nedap.example.org\">info@nedap.example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities http://nictiz.nl/fhir/CapabilityStatement/eOverdracht-servercapabilities}\">Transfer of Care - eOverdracht Server</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirstu3\">https://cp2-test.example.org/fhirstu3</a></p></div>"
        },
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR STU3 Endpoint",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "08013836"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@nedap.example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://nictiz.nl/fhir/CapabilityStatement/eOverdracht-servercapabilities",
                "display" : "Transfer of Care - eOverdracht Server"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp2-test.example.org/fhirstu3"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/2427ca0c-8a29-4a6a-aabd-50cf02f587a7"
      }
    },
    {
      "fullUrl" : "urn:uuid:5cb05355-474b-4d30-8b0e-a9ca574b8274",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "5cb05355-474b-4d30-8b0e-a9ca574b8274",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_5cb05355-474b-4d30-8b0e-a9ca574b8274\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService 5cb05355-474b-4d30-8b0e-a9ca574b8274</b></p><a name=\"5cb05355-474b-4d30-8b0e-a9ca574b8274\"> </a><a name=\"hc5cb05355-474b-4d30-8b0e-a9ca574b8274\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.html\">Organization example Hospital</a></p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0303}\">Chirurgie (Heelkunde)</span>, <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.014}\">Chirurg</span></p><p><b>name</b>: Polikliniek 't Vaatje</p></div>"
        },
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "11429006",
                "display" : "Consultation"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0303",
                "display" : "Chirurgie (Heelkunde)"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.014",
                "display" : "Chirurg"
              }
            ]
          }
        ],
        "name" : "Polikliniek 't Vaatje"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/5cb05355-474b-4d30-8b0e-a9ca574b8274"
      }
    },
    {
      "fullUrl" : "urn:uuid:c79125e5-739f-4238-959c-cd5872518c1f",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "c79125e5-739f-4238-959c-cd5872518c1f",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_c79125e5-739f-4238-959c-cd5872518c1f\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService c79125e5-739f-4238-959c-cd5872518c1f</b></p><a name=\"c79125e5-739f-4238-959c-cd5872518c1f\"> </a><a name=\"hcc79125e5-739f-4238-959c-cd5872518c1f\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.html\">Organization example Hospital</a></p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0308}\">Medisch specialisten, neurochirurgie</span>, <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.025}\">Neurochirurg</span></p><p><b>name</b>: Neurochirurgie</p></div>"
        },
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "11429006",
                "display" : "Consultation"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0308",
                "display" : "Medisch specialisten, neurochirurgie"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.025",
                "display" : "Neurochirurg"
              }
            ]
          }
        ],
        "name" : "Neurochirurgie"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/c79125e5-739f-4238-959c-cd5872518c1f"
      }
    },
    {
      "fullUrl" : "urn:uuid:9d47ca45-4166-4531-a23d-ef5fa613ece4",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "9d47ca45-4166-4531-a23d-ef5fa613ece4",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_9d47ca45-4166-4531-a23d-ef5fa613ece4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService 9d47ca45-4166-4531-a23d-ef5fa613ece4</b></p><a name=\"9d47ca45-4166-4531-a23d-ef5fa613ece4\"> </a><a name=\"hc9d47ca45-4166-4531-a23d-ef5fa613ece4\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.html\">Organization example Hospital</a></p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0305}\">Medisch specialisten, orthopedie</span>, <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.032}\">Orthopedisch chirurg</span></p><p><b>name</b>: Orthopedie</p></div>"
        },
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "11429006",
                "display" : "Consultation"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0305",
                "display" : "Medisch specialisten, orthopedie"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.032",
                "display" : "Orthopedisch chirurg"
              }
            ]
          }
        ],
        "name" : "Orthopedie"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/9d47ca45-4166-4531-a23d-ef5fa613ece4"
      }
    },
    {
      "fullUrl" : "urn:uuid:f6a508bd-9455-4afa-aad0-baec0833602d",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "f6a508bd-9455-4afa-aad0-baec0833602d",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_f6a508bd-9455-4afa-aad0-baec0833602d\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService f6a508bd-9455-4afa-aad0-baec0833602d</b></p><a name=\"f6a508bd-9455-4afa-aad0-baec0833602d\"> </a><a name=\"hcf6a508bd-9455-4afa-aad0-baec0833602d\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.html\">Organization example Hospital</a></p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0313}\">Interne geneeskunde</span>, <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.016}\">Internist</span></p><p><b>name</b>: Interne Geneeskunde</p></div>"
        },
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "11429006",
                "display" : "Consultation"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0313",
                "display" : "Interne geneeskunde"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.016",
                "display" : "Internist"
              }
            ]
          }
        ],
        "name" : "Interne Geneeskunde"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/f6a508bd-9455-4afa-aad0-baec0833602d"
      }
    },
    {
      "fullUrl" : "urn:uuid:120325af-083c-40ee-b16e-01230fe65655",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "120325af-083c-40ee-b16e-01230fe65655",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_120325af-083c-40ee-b16e-01230fe65655\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService 120325af-083c-40ee-b16e-01230fe65655</b></p><a name=\"120325af-083c-40ee-b16e-01230fe65655\"> </a><a name=\"hc120325af-083c-40ee-b16e-01230fe65655\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.html\">Organization example Hospital</a></p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0335}\">Medisch specialisten, geriatrie</span>, <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.022}\">Klinisch geriater</span></p><p><b>name</b>: Geriatrie</p></div>"
        },
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "11429006",
                "display" : "Consultation"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0335",
                "display" : "Medisch specialisten, geriatrie"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.022",
                "display" : "Klinisch geriater"
              }
            ]
          }
        ],
        "name" : "Geriatrie"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/120325af-083c-40ee-b16e-01230fe65655"
      }
    },
    {
      "fullUrl" : "urn:uuid:08013141-16b2-42a0-8c9a-af57cee5511b",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "08013141-16b2-42a0-8c9a-af57cee5511b",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_08013141-16b2-42a0-8c9a-af57cee5511b\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService 08013141-16b2-42a0-8c9a-af57cee5511b</b></p><a name=\"08013141-16b2-42a0-8c9a-af57cee5511b\"> </a><a name=\"hc08013141-16b2-42a0-8c9a-af57cee5511b\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.html\">Organization example Hospital</a></p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0306}\">Medisch specialisten, urologie</span>, <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.045}\">Uroloog</span></p><p><b>name</b>: Urologie</p></div>"
        },
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "11429006",
                "display" : "Consultation"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0306",
                "display" : "Medisch specialisten, urologie"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.045",
                "display" : "Uroloog"
              }
            ]
          }
        ],
        "name" : "Urologie"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/08013141-16b2-42a0-8c9a-af57cee5511b"
      }
    },
    {
      "fullUrl" : "urn:uuid:f051d3bd-26ff-4030-a5b6-fc4ef2be83ba",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "f051d3bd-26ff-4030-a5b6-fc4ef2be83ba",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitionerrole"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_f051d3bd-26ff-4030-a5b6-fc4ef2be83ba\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole f051d3bd-26ff-4030-a5b6-fc4ef2be83ba</b></p><a name=\"f051d3bd-26ff-4030-a5b6-fc4ef2be83ba\"> </a><a name=\"hcf051d3bd-26ff-4030-a5b6-fc4ef2be83ba\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-practitionerrole.html\">NL Generic Functions PractitionerRole Profile</a></p></div><p><b>identifier</b>: <code>http://cp2.example.org/HRM/assignments</code>/123456</p><p><b>practitioner</b>: <a href=\"Practitioner-040b160a-6072-4244-adc0-2b786c4ef052.html\">Practitioner Caroline van Dijk(official)</a></p><p><b>organization</b>: <a href=\"Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.html\">Organization example Hospital</a></p><p><b>code</b>: <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.010}\">Cardioloog</span></p><p><b>specialty</b>: <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.010}\">Cardioloog</span></p><p><b>telecom</b>: <a href=\"mailto:c.vandijk@cp2.example.org\">c.vandijk@cp2.example.org</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://cp2.example.org/HRM/assignments",
            "value" : "123456"
          }
        ],
        "practitioner" : {
          "reference" : "Practitioner/040b160a-6072-4244-adc0-2b786c4ef052"
        },
        "organization" : {
          "reference" : "Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.010",
                "display" : "Cardioloog"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.010",
                "display" : "Cardioloog"
              }
            ]
          }
        ],
        "telecom" : [
          {
            "system" : "email",
            "value" : "c.vandijk@cp2.example.org"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba"
      }
    },
    {
      "fullUrl" : "urn:uuid:040b160a-6072-4244-adc0-2b786c4ef052",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "040b160a-6072-4244-adc0-2b786c4ef052",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitioner",
            "http://nictiz.nl/fhir/StructureDefinition/nl-core-HealthProfessional-Practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_040b160a-6072-4244-adc0-2b786c4ef052\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 040b160a-6072-4244-adc0-2b786c4ef052</b></p><a name=\"040b160a-6072-4244-adc0-2b786c4ef052\"> </a><a name=\"hc040b160a-6072-4244-adc0-2b786c4ef052\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profiles: <a href=\"StructureDefinition-nl-gf-practitioner.html\">NL Generic Functions Practitioner Profile</a>, <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-HealthProfessional-Practitioner\">nl core HealthProfessional Practitioner</a></p></div><p><b>identifier</b>: <code>http://cp2.example.org/HRM/employees</code>/1234, <code>http://fhir.nl/fhir/NamingSystem/uzi</code>/UZI-1</p><p><b>name</b>: Caroline van Dijk(Official)</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://cp2.example.org/HRM/employees",
            "value" : "1234"
          },
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/uzi",
            "value" : "UZI-1"
          }
        ],
        "name" : [
          {
            "use" : "official",
            "text" : "Caroline van Dijk",
            "family" : "van Dijk",
            "given" : ["Caroline"]
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Practitioner/040b160a-6072-4244-adc0-2b786c4ef052"
      }
    }
  ]
}

```
