# NL Generic Functions Organization Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions Organization Profile**

## Resource Profile: NL Generic Functions Organization Profile 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization-lrza | *Version*:0.3.0 |
| Draft as of 2026-01-21 | *Computable Name*:NlGfOrganizationLRZA |

 
The organizational hierarchy and details for healthcare organizations. 

**Usages:**

* Examples for this Profile: [example General Practice](Organization-3f39dca9-a392-4eb3-8366-0c7ff53ab3a9.md), [example Hospital](Organization-4815bbe6-9fea-4875-a16c-a168d63054d4.md), [example Care Institution](Organization-fcf55b06-f22c-4058-9051-b77368bdd26b.md), [example General Practice](Organization-lrza-o1.md)... Show 2 more, [example Hospital](Organization-lrza-o2.md) and [example Care Institution](Organization-lrza-o3.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.nl.gf|current/StructureDefinition/nl-gf-organization-lrza)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-organization-lrza.csv), [Excel](StructureDefinition-nl-gf-organization-lrza.xlsx), [Schematron](StructureDefinition-nl-gf-organization-lrza.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-organization-lrza",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization-lrza",
  "version" : "0.3.0",
  "name" : "NlGfOrganizationLRZA",
  "title" : "NL Generic Functions Organization Profile",
  "status" : "draft",
  "date" : "2026-01-21T15:57:56+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "The organizational hierarchy and details for healthcare organizations.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "zib-healthcareprovider-v3.4-2020EN",
      "uri" : "https://zibs.nl/wiki/HealthcareProvider-v3.4(2020EN)",
      "name" : "zib HealthcareProvider-v3.4(2020EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/nl-core-HealthcareProvider-Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization",
        "constraint" : [
          {
            "key" : "ura-identifier-or-partof",
            "severity" : "error",
            "human" : "an Organization instance must either have an URA-identifier or must be 'partOf' some other instance that is an nl-gf-organization instance.",
            "expression" : "identifier.where(system='http://fhir.nl/fhir/NamingSystem/ura').exists() or partOf.exists()",
            "source" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization-lrza"
          }
        ]
      },
      {
        "id" : "Organization.implicitRules",
        "path" : "Organization.implicitRules",
        "max" : "0"
      },
      {
        "id" : "Organization.modifierExtension",
        "path" : "Organization.modifierExtension",
        "max" : "0"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:AssignedId",
        "path" : "Organization.identifier",
        "sliceName" : "AssignedId",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:AssignedId.system",
        "path" : "Organization.identifier.system",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:AssignedId.value",
        "path" : "Organization.identifier.value",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:AssignedId.assigner",
        "path" : "Organization.identifier.assigner",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:AssignedId.assigner.identifier",
        "path" : "Organization.identifier.assigner.identifier",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:AssignedId.assigner.identifier.type",
        "path" : "Organization.identifier.assigner.identifier.type",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:AssignedId.assigner.identifier.type.coding",
        "path" : "Organization.identifier.assigner.identifier.type.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:AssignedId.assigner.identifier.type.coding.system",
        "path" : "Organization.identifier.assigner.identifier.type.coding.system",
        "patternUri" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type"
      },
      {
        "id" : "Organization.identifier:AssignedId.assigner.identifier.type.coding.code",
        "path" : "Organization.identifier.assigner.identifier.type.coding.code",
        "patternCode" : "author"
      },
      {
        "id" : "Organization.identifier:AssignedId.assigner.identifier.system",
        "path" : "Organization.identifier.assigner.identifier.system",
        "patternUri" : "http://fhir.nl/fhir/NamingSystem/kvk"
      },
      {
        "id" : "Organization.identifier:AssignedId.assigner.identifier.value",
        "path" : "Organization.identifier.assigner.identifier.value",
        "min" : 1
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "min" : 1
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "min" : 1
      }
    ]
  }
}

```
