# Request Revocation status [GFI-003] - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Authentication**](authentication.md)
* **Request Revocation status [GFI-003]**

## Request Revocation status [GFI-003]

### Scope

The transaction Request Revocation Status is used by a verifier to determine the revocation status of a verifiable credential presented by a holder. The verifier sends a request to the revocation registry or authority specified in the credential to determine if the credential is still valid or has been revoked.

### Actor Roles

| | |
| :--- | :--- |
| Verifier | Requests the revocation information of a verifiable credential |
| Issuer | Provides the revocation information which the verifier can use to determine the status |

### Referenced standards

* [Verifiable Credentials Data Model 2.0](https://www.w3.org/TR/vc-data-model/)
* [Bitstring Status List v1.0](https://www.w3.org/TR/vc-bitstring-status-list/)

### Messages

1. Revocation Status Information Request
1. Revocation Status Information Response

#### Revocation Status Information Request

##### Trigger events

* A Holder presents a verifiable credential to a verifier and the verifier needs to check the revocation status of the credential.
* A timer based event to refresh the revocation status information based on the `ValidUntil` field in the status list credential.

##### Message semantics

The verifier initiates a revocation status information request using a HTTP GET request to the revocation URL specified in the verifiable credential under the `credentialStatus` property. Such as specified in the [Bitstring Status List v1.0](https://www.w3.org/TR/vc-bitstring-status-list/) specification.

##### Example

Note: these examples are non normative, for implementation the actual specifications should be followed.

Example of a revocable Verifiable Credential:

```
{
  "@context": [
    "https://www.w3.org/2018/credentials/v1",
    "https://www.w3.org/2018/credentials/examples/v1",
    "https://w3id.org/vc/status-list/2021/v1"
  ],
  "id": "http://example.edu/credentials/3732",
  "type": ["VerifiableCredential", "UniversityDegreeCredential"],
  "issuer": "https://example.edu/issuers/14",
  "issuanceDate": "2020-03-10T04:24:12.164Z",
  "credentialSubject": {
    "id": "did:example:ebfeb1f712ebc6f1c276e12ec21",
    "degree": {
      "type": "BachelorDegree",
      "name": "Bachelor of Science and Arts"
    }
  },
  "credentialStatus": {
    "id": "https://example.edu/status/24#94567",
    "type": "BitstringStatusListEntry",
    "statusPurpose": "revocation",
    "statusListIndex": "94567",
    "statusListCredential": "https://example.edu/status/24"
  },
  "proof": {
    "type": "RsaSignature2018",
    "created": "2020-03-10T04:24:12Z",
    "proofPurpose": "assertionMethod",
    "verificationMethod": "https://example.edu/issuers/keys/1",
    "jws": "..."
  }
}

```

This results in the following request:

```
GET https://example.edu/status/24

```

#### Revocation Status Information Response

##### Trigger events

The requested party responds to the revocation status information request.

##### Message semantics

The Issuer should respond with the latest version of the status list credential, signed with the Issuer's proofing method.

##### Example

Note: these examples are non normative, for implementation the actual specifications should be followed.

Example of a Status List Credential response:

```
{
  "@context": [
    "https://www.w3.org/2018/credentials/v1",
    "https://w3id.org/vc/status-list/2021/v1"
  ],
  "id": "https://example.edu/status/24",
  "type": ["VerifiableCredential", "StatusList2021Credential"],
  "issuer": "https://example.edu/issuers/14",
  "validFrom": "2025-03-10T04:24:12Z",
  "ValidUntil": "2025-03-10T08:24:12Z",
  "credentialSubject": {
    "id": "https://example.edu/status/24#list",
    "type": "BitstringStatusList",
    "statusPurpose": "revocation",
    "encodedList": "H4sIAAAAAAAAA-3BMQEAAADCoPVPbQwfoAAAAAAAAAAAAAAAAPgG6AAB"
  },
  "proof": {
    "type": "RsaSignature2018",
    "created": "2020-03-10T04:24:12Z",
    "proofPurpose": "assertionMethod",
    "verificationMethod": "https://example.edu/issuers/keys/1",
    "jws": "..."
  }
}

```

##### Expected actions

The verifier processes the status list credential as specified by the [Validate Algorithm section of the specification](https://www.w3.org/TR/vc-bitstring-status-list/#validate-algorithm) to determine the revocation status of the verifiable credential presented by the holder. The verifier decodes the `encodedList` field to obtain the bitstring representing the revocation status of credentials. The verifier checks the bit at the index specified in the `statusListIndex` field of the verifiable credential's `credentialStatus` property. If the bit is set to `1`, the credential is revoked; if it is set to `0`, the credential is valid.

