# Issue Claims [GFI-002] - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Authentication**](authentication.md)
* **Issue Claims [GFI-002]**

## Issue Claims [GFI-002]

### Scope

The Issue Claims transaction describes the process of issuing verifiable claims from an authoritative issuer to a holder. The claims are typically encapsulated within a verifiable credential, which the holder can later present to verifiers as proof of certain attributes or qualifications. The Issue Claims transaction can be initiated by the holder or the issuer, depending on the use case and the relationship between the parties involved.

#### Optionality

This transaction is optional and provides a standardized way requesting and transferring verifiable claims between an issuer and a holder. It is possible to request, issue and transfer these claims using other protocols such as email or other messaging systems.

### Actor Roles

| | |
| :--- | :--- |
| Issuer | Issues verifiable claims to a holder in the form of a verifiable credential |
| Holder | Receives verifiable claims from the issuer and stores them securely |

### Referenced standards

* [Verifiable Credentials Data Model 1.0](https://www.w3.org/TR/vc-data-model/)
* [OpenID4VCI](https://openid.net/specs/openid-4-verifiable-credential-issuance-1_0.html)

### Messages

1. Credential Offer
1. Credential Request
1. Credential Response

