# Organization 2 - Endpoint DICOM-WADO-RS - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 2 - Endpoint DICOM-WADO-RS**

## Example Endpoint: Organization 2 - Endpoint DICOM-WADO-RS

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**status**: Active

**connectionType**: [Endpoint Connection Type: dicom-wado-rs](http://terminology.hl7.org/7.0.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-dicom-wado-rs) (DICOM WADO-RS)

**name**: DICOM-WADO-RS Endpoint

**managingOrganization**: Identifier: `http://fhir.nl/fhir/NamingSystem/kvk`/08013836

**contact**: [+3131599991](tel:+3131599991), [info@nedap.example.org](mailto:info@nedap.example.org)

**payloadType**: Any

**address**: [https://cp2-test.example.org/dicom-wado-rs](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/dicom-wado-rs)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "d4c1d657-67a9-471c-9732-9c042e9a6d43",
  "meta" : {
    "profile" : [
      "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
    ]
  },
  "status" : "active",
  "connectionType" : {
    "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
    "code" : "dicom-wado-rs"
  },
  "name" : "DICOM-WADO-RS Endpoint",
  "managingOrganization" : {
    "identifier" : {
      "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
      "value" : "08013836"
    }
  },
  "contact" : [
    {
      "system" : "phone",
      "value" : "+3131599991",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@nedap.example.org",
      "use" : "work"
    }
  ],
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-payload-type",
          "code" : "any",
          "display" : "Any"
        }
      ]
    }
  ],
  "address" : "https://cp2-test.example.org/dicom-wado-rs"
}

```
