# Administration Directory for Administration Client - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Administration Directory for Administration Client**

## CapabilityStatement: Administration Directory for Administration Client 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-admin-client | *Version*:0.3.0 |
| Active as of 2025-08-28 | *Computable Name*: |

 
Dutch profile of the CapabilityStatement for Administration Directory Actor that should be able to work with an Administration Client 

 [Raw OpenAPI-Swagger Definition file](nl-gf-admin-directory-admin-client.openapi.json) | [Download](nl-gf-admin-directory-admin-client.openapi.json) 

## Administration Directory for Administration Client

* Implementation Guide Version: 0.3.0 
* FHIR Version: 4.0.1 
* Supported Formats: `application/fhir+xml`, `application/fhir+json`
* Published on: 2025-08-28 
* Published by: Stichting Nuts 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

## FHIR RESTful Capabilities

### Mode: server

Dutch profile of the IHE ITI-130 endpoint

**Summary of System-wide Interactions**

* **SHALL**support the `transaction`interaction.

### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [HealthcareService](#HealthcareService1-1) | Supported Profiles  [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md) |  |  | **Y** | **Y** | y? |  |  |  |  |
| [Location](#Location1-2) | Supported Profiles  [NL Generic Functions Location Profile](StructureDefinition-nl-gf-location.md) |  |  | **Y** | **Y** | y? |  |  |  |  |
| [Organization](#Organization1-3) | Supported Profiles  [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md) |  |  | **Y** | **Y** | y? |  |  |  |  |
| [Practitioner](#Practitioner1-4) | Supported Profiles  [NL Generic Functions Practitioner Profile](StructureDefinition-nl-gf-practitioner.md) |  |  | **Y** | **Y** | y? |  |  |  |  |
| [PractitionerRole](#PractitionerRole1-5) | Supported Profiles  [NL Generic Functions PractitionerRole Profile](StructureDefinition-nl-gf-practitionerrole.md) |  |  | **Y** | **Y** | y? |  |  |  |  |
| [Endpoint](#Endpoint1-6) | Supported Profiles  [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md) |  |  | **Y** | **Y** | 🛇? |  |  |  |  |
| [OrganizationAffiliation](#OrganizationAffiliation1-7) | Supported Profiles  [NL Generic Functions OrganizationAffiliation Profile](StructureDefinition-nl-gf-organizationaffiliation.md) |  |  | **Y** | **Y** | y? |  |  |  |  |

-------

#### Resource Conformance: MAY HealthcareService

Core FHIR Resource

[HealthcareService](http://hl7.org/fhir/R4/healthcareservice.html)

Reference Policy

Interaction summary

* **SHALL** support `create`, `update`.
* **MAY** support `delete`.

Supported Profiles
[NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

Documentation
> 

.


#### Resource Conformance: MAY Location

Core FHIR Resource

[Location](http://hl7.org/fhir/R4/location.html)

Reference Policy

Interaction summary

* **SHALL** support `create`, `update`.
* **MAY** support `delete`.

Supported Profiles
[NL Generic Functions Location Profile](StructureDefinition-nl-gf-location.md)

Documentation
> 

.


#### Resource Conformance: MAY Organization

Core FHIR Resource

[Organization](http://hl7.org/fhir/R4/organization.html)

Reference Policy

Interaction summary

* **SHALL** support `create`, `update`.
* **MAY** support `delete`.

Supported Profiles
[NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

Documentation
> 

.


#### Resource Conformance: MAY Practitioner

Core FHIR Resource

[Practitioner](http://hl7.org/fhir/R4/practitioner.html)

Reference Policy

Interaction summary

* **SHALL** support `create`, `update`.
* **MAY** support `delete`.

Supported Profiles
[NL Generic Functions Practitioner Profile](StructureDefinition-nl-gf-practitioner.md)

Documentation
> 

.


#### Resource Conformance: MAY PractitionerRole

Core FHIR Resource

[PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html)

Reference Policy

Interaction summary

* **SHALL** support `create`, `update`.
* **MAY** support `delete`.

Supported Profiles
[NL Generic Functions PractitionerRole Profile](StructureDefinition-nl-gf-practitionerrole.md)

Documentation
> 

.


#### Resource Conformance: MAY Endpoint

Core FHIR Resource

[Endpoint](http://hl7.org/fhir/R4/endpoint.html)

Reference Policy

Interaction summary

* **SHALL** support `create`, `update`.
* **SHOULD-NOT** support `delete`.

Supported Profiles
[NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

Documentation
> 

.


#### Resource Conformance: MAY OrganizationAffiliation

Core FHIR Resource

[OrganizationAffiliation](http://hl7.org/fhir/R4/organizationaffiliation.html)

Reference Policy

Interaction summary

* **SHALL** support `create`, `update`.
* **MAY** support `delete`.

Supported Profiles
[NL Generic Functions OrganizationAffiliation Profile](StructureDefinition-nl-gf-organizationaffiliation.md)

Documentation
> 

.




## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "nl-gf-admin-directory-admin-client",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-admin-client",
  "version" : "0.3.0",
  "title" : "Administration Directory for Administration Client",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-08-28",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "Dutch profile of the CapabilityStatement for Administration Directory Actor that should be able to work with an Administration Client",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["application/fhir+xml", "application/fhir+json"],
  "rest" : [
    {
      "mode" : "server",
      "documentation" : "Dutch profile of the IHE ITI-130 endpoint",
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "HealthcareService",
          "supportedProfile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ],
          "documentation" : ".",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Location",
          "supportedProfile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-location"
          ],
          "documentation" : ".",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Organization",
          "supportedProfile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
          ],
          "documentation" : ".",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Practitioner",
          "supportedProfile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitioner"
          ],
          "documentation" : ".",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "PractitionerRole",
          "supportedProfile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitionerrole"
          ],
          "documentation" : ".",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Endpoint",
          "supportedProfile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ],
          "documentation" : ".",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD-NOT"
                }
              ],
              "code" : "delete"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "OrganizationAffiliation",
          "supportedProfile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organizationaffiliation"
          ],
          "documentation" : ".",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            }
          ]
        }
      ],
      "interaction" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "code" : "transaction"
        }
      ]
    }
  ]
}

```
