# NL GF WLZ Zorgprofielen ValueSet - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL GF WLZ Zorgprofielen ValueSet**

## ValueSet: NL GF WLZ Zorgprofielen ValueSet (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/ValueSet/nl-gf-wlz-zorgprofielen-vs | *Version*:0.3.0 |
| Active as of 2026-01-06 | *Computable Name*:NlGfWlzZorgprofielenVS |

 
The WLZ Zorgprofielen supported by the NL Generic Functions. 

 **References** 

* [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "nl-gf-wlz-zorgprofielen-vs",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/ValueSet/nl-gf-wlz-zorgprofielen-vs",
  "version" : "0.3.0",
  "name" : "NlGfWlzZorgprofielenVS",
  "title" : "NL GF WLZ Zorgprofielen ValueSet",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-06T16:04:47+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "The WLZ Zorgprofielen supported by the NL Generic Functions.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "http://decor.nictiz.nl/fhir/ValueSet/2.16.840.1.113883.2.4.3.11.60.121.11.19--20200901000000"
        ]
      },
      {
        "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-wlz-zorgprofielen-cs"
      }
    ]
  }
}

```
