# NL Generic Functions EpisodeOfCare Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions EpisodeOfCare Profile**

## Resource Profile: NL Generic Functions EpisodeOfCare Profile 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-episodeofcare | *Version*:0.3.0 |
| Draft as of 2026-01-06 | *Computable Name*:NlGfEpisodeOfCare |

 
An association between a patient and an organization / healthcare provider during which time encounters may occur. 

**Usages:**

* CapabilityStatements using this Profile: [Localization Service](CapabilityStatement-nl-gf-localization-gp-repository.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.nl.gf|current/StructureDefinition/nl-gf-episodeofcare)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-episodeofcare.csv), [Excel](StructureDefinition-nl-gf-episodeofcare.xlsx), [Schematron](StructureDefinition-nl-gf-episodeofcare.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-episodeofcare",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-episodeofcare",
  "version" : "0.3.0",
  "name" : "NlGfEpisodeOfCare",
  "title" : "NL Generic Functions EpisodeOfCare Profile",
  "status" : "draft",
  "date" : "2026-01-06T16:04:47+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "An association between a patient and an organization / healthcare provider during which time encounters may occur.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "zib-episodeofcare-v1.0-2020EN",
      "uri" : "https://zibs.nl/wiki/EpisodeOfCare-v1.0(2020EN)",
      "name" : "zib EpisodeOfCare-v1.0(2020EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "EpisodeOfCare",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/nl-core-EpisodeOfCare",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "EpisodeOfCare",
        "path" : "EpisodeOfCare"
      },
      {
        "id" : "EpisodeOfCare.identifier",
        "path" : "EpisodeOfCare.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "EpisodeOfCare.identifier:AssignedId",
        "path" : "EpisodeOfCare.identifier",
        "sliceName" : "AssignedId",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "EpisodeOfCare.identifier:AssignedId.system",
        "path" : "EpisodeOfCare.identifier.system",
        "min" : 1
      },
      {
        "id" : "EpisodeOfCare.identifier:AssignedId.value",
        "path" : "EpisodeOfCare.identifier.value",
        "min" : 1
      },
      {
        "id" : "EpisodeOfCare.identifier:AssignedId.assigner",
        "path" : "EpisodeOfCare.identifier.assigner",
        "min" : 1
      },
      {
        "id" : "EpisodeOfCare.identifier:AssignedId.assigner.identifier",
        "path" : "EpisodeOfCare.identifier.assigner.identifier",
        "min" : 1
      },
      {
        "id" : "EpisodeOfCare.identifier:AssignedId.assigner.identifier.type",
        "path" : "EpisodeOfCare.identifier.assigner.identifier.type",
        "min" : 1
      },
      {
        "id" : "EpisodeOfCare.identifier:AssignedId.assigner.identifier.type.coding",
        "path" : "EpisodeOfCare.identifier.assigner.identifier.type.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "EpisodeOfCare.identifier:AssignedId.assigner.identifier.type.coding.system",
        "path" : "EpisodeOfCare.identifier.assigner.identifier.type.coding.system",
        "patternUri" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type"
      },
      {
        "id" : "EpisodeOfCare.identifier:AssignedId.assigner.identifier.type.coding.code",
        "path" : "EpisodeOfCare.identifier.assigner.identifier.type.coding.code",
        "patternCode" : "author"
      },
      {
        "id" : "EpisodeOfCare.identifier:AssignedId.assigner.identifier.system",
        "path" : "EpisodeOfCare.identifier.assigner.identifier.system",
        "patternUri" : "http://fhir.nl/fhir/NamingSystem/ura"
      },
      {
        "id" : "EpisodeOfCare.identifier:AssignedId.assigner.identifier.value",
        "path" : "EpisodeOfCare.identifier.assigner.identifier.value",
        "min" : 1
      }
    ]
  }
}

```
