# Routing - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* **Routing**

## Routing

> This is a copy of the Technical Agreement "Routering" and is maintained outside this Implementation Guide. The reason to include it in this IG:
* generate examples
* consistency with the Generic Functions

| | |
| :--- | :--- |
| Titel | Technical Agreement 'Publishing, routing and defining requests between care providers' |
| Version | 1.1 |
| Published by | Twiin |
| Website | https://www.twiin.nl/ |

### Introduction

This Technical Agreement (TA) specifies responsibilities and patterns for routing referrals and orders between healthcare organizations, leveraging the IHE mCSD (Mobile Care Services Directory) model. The central principle is that routing is based on a structured directory lookup. The initial reason for drawing up this generic technical agreement is the need for a mechanism to address the notification, as described in the TA Notified Pull, at the right place within the receiving organization. Addressing the notification at the level of a healthcare organization isn’t enough for end users.

#### Goal, scope, and principles

##### Goal

The mechanism defined in this document is intended to provide a single and simple mechanism of routing labels (persons, suborganizations, locations, products, and services) within an organization and to allow organizations to define such routing labels.

##### Scope of this proposal

This TA applies to scenarios where information exchange involves:

* Publishing (sub-)organizations, practitioners, and locations as routing labels in an mCSD Directory
* Selecting a (sub-)organization, practitioner, or location from a structured directory using activity types/definitions in healthcare services
* Creating (clinical) requests and (logistic) tasks for the (sub-)organization, practitioner, or location
* Sending notifications to the corresponding endpoint of the (sub-)organization, practitioner, or location

This technical agreement is intended to be infrastructure agnostic. Authorization is out of scope for now. Authorization can be useful to prevent that someone requests a service that he is not allowed to request.

##### Examples of supported routing use cases:

* Requesting care at a specific geographic location
* Referring to a department or specialist within an organization
* Requesting a specific healthcare service (e.g., CT scan)

##### Targeted FHIR-version and profiles

This TA assumes use of FHIR STU3 or R4 resources and is compatible with IHE mCSD directory concepts. The IHE mCSD directory defines resource types for all the relevant concepts. In addition, the HCIMs define profiles on most of these resources: Location, Organization, Practitioner, and PractitionerRole have HCIMs defined. Endpoint and HealthcareService are available in FHIR, but not as HCIM.

##### Principles

The following principles are followed in this document:

* Use international standards where applicable
* Align with FHIR Workflow, Implementation Guide Clinical Order Workflow, and IHE mCSD
* Minimize custom extensions or non-standard patterns
* Ensure design longevity (3–5 years applicability)

#### Definition of terms

| | |
| :--- | :--- |
| Endpoint | The base address for interfacing with a service |
| HealthcareService | A service offered by a healthcare organization (FHIR resource) |
| Organization | A grouping of people or organizations with a common purpose |
| Receiving Organization | The organization or party to receive a message or request |
| Receiving System | The system a message or request for the receiving organization is sent to |
| Sending Organization | The organization or party sending a message or request to the receiving organization |
| Sending System | The system sending a message or request on behalf of the sending organization |
| ServiceRequest | A request for service such as diagnostic investigations, treatments, or operations to be performed |
| System | Software used by (a) healthcare organization(s), such as an electronic health record or API service |
| Task | Workflow-related administrative activity in FHIR |

### Routing interactions

This chapter describes all relevant interactions on data level.

#### mCSD-Based Directory Lookup

Routing is based on the IHE mCSD model, in which each care provider publishes Organization, Location, HealthcareService, and Endpoint resources in a mCSD Directory. Users (or their systems) search the directory for a suitable HealthcareService and construct a FHIR ServiceRequest (R4) or ReferralRequest (STU3) and Task.

##### Interaction flow:

1. Care providers publish structured addressable resources to the directory
1. The sender searches for the appropriate service (e.g. “initial consultation” for “radiology” near “Zwolle”) in a Care Service (Query) Directory ([example content of a Query Directory](./Bundle-query-directory.md))
1. The resulting HealthcareService (indirectly) refers to Organization, Location, Endpoint, etc.
1. This is used in the ServiceRequest ([example](./ServiceRequest-53a41e63-e826-45fa-9076-9be4b18399c8.md)) and Task ([example](./Task-a0fc5221-bcd9-46f1-922f-c2913dae5d63.md))

##### Role of the ServiceRequest

The ServiceRequest represents the ‘clinical intent’ or ‘clinical authorization’ for a procedure. It shall have a ServiceRequest.code (representing e.g. ‘initial consultation’ or ‘nursing handoff’). Detailed ServiceRequests may use an ActivityDefinition to define what requested for the patient in ServiceRequest.instantiatesCanonical.

##### Role of the Task

The Task is used for state management and administrative routing (I.e ‘who’ and ‘where’ should do the referred ServiceRequest). The Task.code is used to define what the Task.owner is exepted do with the referred ServiceRequest, e.g. ‘fulfill’, ‘change’ or ‘approve’.

##### Role of the HealthcareService

The HealthcareService is used to publish supported activities (using codeable concepts in element.type and references to ActivityDefinitions and PlanDefinitions in element.type.extension:supportedActivityDefinitions). These items are primarily used in the Request.

The HealthcareService also points to the (sub-)organization that provides the HealthcareService. This organization should be used as Task.owner.

The HealthcareService.location may point to (multiple) physical locations where the service can be performed. If the HealthcareService does not specify a location, the location can be inherited from the organization (or, recursively, parent organizations) that provides the service.

The HealthcareService.endpoint may contain a suitable Endpoint resource (e.g. an Endpoint that is capable of receiving FHIR notifications like TA-NP specifies). If the HealthcareService does not specify an endpoint, the endpoint can be inherited from the organization (or, recursively, parent organizations) that provides the service.

#### HealthcareService profile

The [NL-GF-HealthcareService profile](./StructureDefinition-nl-gf-healthcareservice.md) is based on the core FHIR R4 HealthcareService, incorporating changes from IHE mCSD, a valueset-binding on .type and .specialty, and an extension on .type to refer to Activity/PlanDefinitions.

### Document management

#### Involved parties

This document is a co-creation of the companies listed below. The following people have been involved in creating this document.

| | | |
| :--- | :--- | :--- |
| Chipsoft | Olav Trauschke | o.trauschke@chipsoft.com |
| Nedap | Pieter Bos, Roald Dijkstra |   |
| Nexus | Marcel Engels | marcel.engels@nexus-nederland.nl |
| Nictiz | Pieter Edelman |   |
| Twiin | Marc Sandberg, Robin van Everdingen |   |
| VZVZ1 | Ron van Holland |   |
| ZorgDomein | Stephan Opdenberg, Ruben Pape |   |
| Nuts | Bram Wesselo |   |

#### Version control

| | | | |
| :--- | :--- | :--- | :--- |
| 1.0.1 | December 19th 2024 |   | An example of eOverdracht has been added. Example of BgZ has been supplemented for missing parts. An attribute in table 2.3 (assessment) has been removed because it added nothing. |
| 1.1 | August 28th 2025 |   | The role of ActivityDefinition has been revised. Some elements are now covered by the concept of the HealthcareService. |

