# Artifacts Summary - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [Administration Directory for Administration Client](CapabilityStatement-nl-gf-admin-directory-admin-client.md) | Dutch profile of the CapabilityStatement for Administration Directory Actor that should be able to work with an Administration Client |
| [Administration Directory for Update Client](CapabilityStatement-nl-gf-admin-directory-update-client.md) | Dutch profile of the CapabilityStatement for Administration Directory Actor that should be able to work with an Update Client. |
| [Localization Service](CapabilityStatement-nl-gf-localization-repository.md) | Dutch profile of the CapabilityStatement for a Localization Service. |
| [Query Directory for Query Client](CapabilityStatement-nl-gf-query-directory-query-client.md) | Dutch profile of the CapabilityStatement for Query Directory Actor that should be able to work with an Query Client. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md) | The technical details of an endpoint that can be used for electronic services, such as for web services providing access to FHIR resources. |
| [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md) | The technical details of a healthcare service that can be used in referrals, requests and orders |
| [NL Generic Functions Localization DocumentReference Profile](StructureDefinition-nl-gf-localization-documentreference.md) | A DocumentReference profile for registering the availability of patient data at healthcare organizations for localization services. This profile is used to indicate that certain patient data is available at a specific organization and can be accessed for localization purposes. |
| [NL Generic Functions Location Profile](StructureDefinition-nl-gf-location.md) | Physical location details for healthcare services, organizations, and practitioners. |
| [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md) | The organizational hierarchy and details for healthcare organizations. |
| [NL Generic Functions OrganizationAffiliation Profile](StructureDefinition-nl-gf-organizationaffiliation.md) | The details of an affiliation/relationship between two organizations, such as a healthcare provider and a software vendor. |
| [NL Generic Functions Practitioner Profile](StructureDefinition-nl-gf-practitioner.md) | The details of a healthcare practitioner, such as a doctor or nurse, who is directly or indirectly involved in the provisioning of healthcare. |
| [NL Generic Functions PractitionerRole Profile](StructureDefinition-nl-gf-practitionerrole.md) | The details of a healthcare practitioner's role within an organization. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Supported ActivityDefinitions and PlanDefinitions by HealthcareServices](StructureDefinition-supported-activity-definitions.md) | ActivityDefinitions or PlanDefinitions to specify the codeable concepts in HealthcareService.type. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [NL GF Data exchange capabilities](ValueSet-nl-gf-data-exchange-capabilities-vs.md) | The data exchange capabilities supported by the NL Generic Functions. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [NL GF Data exchange capabilities](CodeSystem-nl-gf-data-exchange-capabilities.md) | Local code system for NL Generic Functions. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Bundle of care services in ECD of Organization 3](Bundle-admin-directory-org3.md) | This bundle contains all care services for the Organization 3 Administration Directory example |
| [Bundle of care services in EHR of Organization 2](Bundle-admin-directory-org2.md) | This bundle contains all care services for the Organization 2 Administration Directory example |
| [Bundle of care services in HIS of Organization 1](Bundle-admin-directory-org1.md) | This bundle contains all care services for the Organization 1 Administration Directory example |
| [Bundle of care services in LRZa](Bundle-admin-directory-lrza.md) | This bundle contains all care services for the LRZa Administration Directory example |
| [Bundle of care services in Query Directory](Bundle-query-directory.md) | This bundle contains all care services from each Administration Directory for the Query Directory example |
| [Bundle of personal health information in ECD of Organization 3](Bundle-phi-org3.md) | This bundle contains all personal health information for Patient Jaantje Merkens in Organization 3 |
| [Bundle of personal health information in EHR of Organization 2](Bundle-phi-org2.md) | This bundle contains all personal health information for Patient Jaantje Merkens in Organization 2 |
| [Bundle of personal health information in HIS of Organization 1](Bundle-phi-org1.md) | This bundle contains all personal health information for Patient Jaantje Merkens in Organization 1 |
| [Example NL Generic Functions Localization DocumentReference](DocumentReference-52b792ba-11ae-42f3-bcc1-231f333f2317.md) | Example instance of the NlGfLocalizationDocumentReference profile. |
| [LRZa - Organization 1 - Endpoint](Endpoint-ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4.md) |  |
| [LRZa - Organization 1 - Organization](Organization-3f39dca9-a392-4eb3-8366-0c7ff53ab3a9.md) |  |
| [LRZa - Organization 2 - Endpoint](Endpoint-960a4f8c-74d8-482c-97ab-e2a025869fee.md) |  |
| [LRZa - Organization 2 - Organization](Organization-4815bbe6-9fea-4875-a16c-a168d63054d4.md) |  |
| [LRZa - Organization 3 - Endpoint](Endpoint-553416dd-da12-40f7-a9bd-eb3e193177bd.md) |  |
| [LRZa - Organization 3 - Organization](Organization-fcf55b06-f22c-4058-9051-b77368bdd26b.md) |  |
| [Organisation 2 - ServiceRequest Nursing](ServiceRequest-53a41e63-e826-45fa-9076-9be4b18399c8.md) | Request from Organization 2 for nursing care |
| [Organization 1 - Endpoint](Endpoint-59654248-477c-4694-b156-e0042f0765a6.md) |  |
| [Organization 1 - Organization](Organization-4cb35b96-f021-4e15-bf71-d67a6d4bebec.md) |  |
| [Organization 1 - Practitioner Harry Arts](Practitioner-9a63e407-34af-4ae4-ad3c-f7107fbbc0cd.md) |  |
| [Organization 1 - PractitionerRole Harry Arts](PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.md) |  |
| [Organization 2 - Endpoint DICOM-WADO-RS](Endpoint-d4c1d657-67a9-471c-9732-9c042e9a6d43.md) |  |
| [Organization 2 - Endpoint FHIR R4](Endpoint-430f7379-8ec2-4e55-b096-919995da61e2.md) |  |
| [Organization 2 - Endpoint FHIR STU3](Endpoint-2427ca0c-8a29-4a6a-aabd-50cf02f587a7.md) |  |
| [Organization 2 - HealthcareService Cardiology](HealthcareService-5cb05355-474b-4d30-8b0e-a9ca574b8274.md) |  |
| [Organization 2 - HealthcareService Geriatrie](HealthcareService-120325af-083c-40ee-b16e-01230fe65655.md) |  |
| [Organization 2 - HealthcareService Interne Geneeskunde](HealthcareService-f6a508bd-9455-4afa-aad0-baec0833602d.md) |  |
| [Organization 2 - HealthcareService Neurochirurgie](HealthcareService-c79125e5-739f-4238-959c-cd5872518c1f.md) |  |
| [Organization 2 - HealthcareService Orthopedie](HealthcareService-9d47ca45-4166-4531-a23d-ef5fa613ece4.md) |  |
| [Organization 2 - HealthcareService Urologie](HealthcareService-08013141-16b2-42a0-8c9a-af57cee5511b.md) |  |
| [Organization 2 - Organization](Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.md) |  |
| [Organization 2 - Practitioner Cardioloog Caroline van Dijk](Practitioner-040b160a-6072-4244-adc0-2b786c4ef052.md) |  |
| [Organization 2 - PractitionerRole Cardioloog Caroline van Dijk at Organization 2](PractitionerRole-f051d3bd-26ff-4030-a5b6-fc4ef2be83ba.md) |  |
| [Organization 2 - Task for ServiceRequest Nursing](Task-a0fc5221-bcd9-46f1-922f-c2913dae5d63.md) | Task created by Organization 2 to fulfill the ServiceRequest for nursing care at Nursing department at Organization 3 |
| [Organization 3 - Endpoint FHIR R4](Endpoint-8f224548-6d50-44b6-82c5-75826ee0900f.md) |  |
| [Organization 3 - Endpoint FHIR STU3](Endpoint-72a349cc-7336-4a91-873d-fc9349769e1a.md) |  |
| [Organization 3 - HealthcareService Geriatrie](HealthcareService-4fcf98c7-b198-4d61-8b3e-5ea39e33c405.md) |  |
| [Organization 3 - HealthcareService Verpleging](HealthcareService-b48826dc-2d58-479a-bfd3-80b7a9d69757.md) |  |
| [Organization 3 - Organization Nursing department](Organization-631cf10e-42d6-4165-9907-11e2333d4a85.md) | Nursing department at Organization 3 |
| [Organization 3 - Practitioner John Doe](Practitioner-08630c28-5e2a-4b0c-b8ce-f08f533246b9.md) |  |
| [Organization 3 - PractitionerRole Klinisch Geriater John Doe](PractitionerRole-d60525bd-5caf-4437-8f4b-4156300a27de.md) |  |
| [Organization 3- Organization](Organization-3e799075-63a2-4a4c-913d-a91b8198463d.md) |  |
| [Patient Jaantje Merkens](Patient-27e58ece-409e-44f9-8cc1-b33495a0ef9d.md) | Patient Jaantje Merkens in EHR of Organization 2 |

