# Organization 3 - Endpoint FHIR R4 - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 3 - Endpoint FHIR R4**

## Example Endpoint: Organization 3 - Endpoint FHIR R4

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**status**: Active

**connectionType**: [Endpoint Connection Type: hl7-fhir-rest](http://terminology.hl7.org/7.0.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest) (HL7 FHIR)

**name**: FHIR R4 Endpoint

**managingOrganization**: Identifier: `http://fhir.nl/fhir/NamingSystem/kvk`/34270859

**contact**: [+3131599991](tel:+3131599991), [info@example.org](mailto:info@example.org)

**payloadType**: Care Services Directory for Update Client

**payloadMimeType**: application/fhir+json

**address**: [https://cp3-test.example.org/fhirr4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp3-test.example.org/fhirr4)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "8f224548-6d50-44b6-82c5-75826ee0900f",
  "meta" : {
    "profile" : [
      "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
    ]
  },
  "status" : "active",
  "connectionType" : {
    "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
    "code" : "hl7-fhir-rest"
  },
  "name" : "FHIR R4 Endpoint",
  "managingOrganization" : {
    "identifier" : {
      "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
      "value" : "34270859"
    }
  },
  "contact" : [
    {
      "system" : "phone",
      "value" : "+3131599991",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@example.org",
      "use" : "work"
    }
  ],
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
          "code" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client",
          "display" : "Care Services Directory for Update Client"
        }
      ]
    }
  ],
  "payloadMimeType" : ["application/fhir+json"],
  "address" : "https://cp3-test.example.org/fhirr4"
}

```
