# Organization 3 - Location Nursing Department - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 3 - Location Nursing Department**

## Example Location: Organization 3 - Location Nursing Department

Profile: [NL Generic Functions Location Profile](StructureDefinition-nl-gf-location.md)

**identifier**: `https://cp3-test.example.org/locations`/9a2b8f1c-4e7d-42a1-b3c9-2d5e8f7a6c1b

**status**: Active

**name**: Verpleeghuis Weltevree

**type**: Skilled nursing facility

**address**: Doetinchem NL 

**managingOrganization**: [Organization Nursing department at Organization 3](Organization-631cf10e-42d6-4165-9907-11e2333d4a85.md)



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "9a2b8f1c-4e7d-42a1-b3c9-2d5e8f7a6c1b",
  "meta" : {
    "profile" : [
      "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-location"
    ]
  },
  "identifier" : [
    {
      "system" : "https://cp3-test.example.org/locations",
      "value" : "9a2b8f1c-4e7d-42a1-b3c9-2d5e8f7a6c1b",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "33333333"
        }
      }
    }
  ],
  "status" : "active",
  "name" : "Verpleeghuis Weltevree",
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "SNF",
          "display" : "Skilled nursing facility"
        }
      ]
    }
  ],
  "address" : {
    "city" : "Doetinchem",
    "country" : "NL"
  },
  "managingOrganization" : {
    "reference" : "Organization/631cf10e-42d6-4165-9907-11e2333d4a85"
  }
}

```
