# Organization 2 - HealthcareService Urologie - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 2 - HealthcareService Urologie**

## Example HealthcareService: Organization 2 - HealthcareService Urologie

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**identifier**: `https://cp2-test.example.org/services`/08013141-16b2-42a0-8c9a-af57cee5511b

**active**: true

**providedBy**: [Organization example Hospital](Organization-ad2-o1.md)

**type**: Consultation

**specialty**: Medisch specialisten, urologie, Uroloog

**name**: Urologie



## Resource Content

```json
{
  "resourceType" : "HealthcareService",
  "id" : "ad2-hs6",
  "meta" : {
    "profile" : [
      "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
    ]
  },
  "identifier" : [
    {
      "system" : "https://cp2-test.example.org/services",
      "value" : "08013141-16b2-42a0-8c9a-af57cee5511b",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "22222222"
        }
      }
    }
  ],
  "active" : true,
  "providedBy" : {
    "reference" : "Organization/ad2-o1"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "11429006",
          "display" : "Consultation"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
          "code" : "0306",
          "display" : "Medisch specialisten, urologie"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
          "code" : "01.045",
          "display" : "Uroloog"
        }
      ]
    }
  ],
  "name" : "Urologie"
}

```
