# Organization 2 - HealthcareService Orthopedie - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 2 - HealthcareService Orthopedie**

## Example HealthcareService: Organization 2 - HealthcareService Orthopedie

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**identifier**: `https://cp2-test.example.org/services`/9d47ca45-4166-4531-a23d-ef5fa613ece4

**active**: true

**providedBy**: [Organization example Hospital](Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.md)

**type**: Consultation

**specialty**: Medisch specialisten, orthopedie, Orthopedisch chirurg

**name**: Orthopedie



## Resource Content

```json
{
  "resourceType" : "HealthcareService",
  "id" : "9d47ca45-4166-4531-a23d-ef5fa613ece4",
  "meta" : {
    "profile" : [
      "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
    ]
  },
  "identifier" : [
    {
      "system" : "https://cp2-test.example.org/services",
      "value" : "9d47ca45-4166-4531-a23d-ef5fa613ece4",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "22222222"
        }
      }
    }
  ],
  "active" : true,
  "providedBy" : {
    "reference" : "Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "11429006",
          "display" : "Consultation"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
          "code" : "0305",
          "display" : "Medisch specialisten, orthopedie"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
          "code" : "01.032",
          "display" : "Orthopedisch chirurg"
        }
      ]
    }
  ],
  "name" : "Orthopedie"
}

```
