# NL Generic Functions OrganizationAffiliation Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions OrganizationAffiliation Profile**

## Resource Profile: NL Generic Functions OrganizationAffiliation Profile 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organizationaffiliation | *Version*:0.2.0 |
| Draft as of 2025-10-15 | *Computable Name*:NlGfOrganizationAffiliation |

 
The details of an affiliation/relationship between two organizations, such as a healthcare provider and a software vendor. 

**Usages:**

* CapabilityStatements using this Profile: [Administration Directory for Administration Client](CapabilityStatement-nl-gf-admin-directory-admin-client.md), [Administration Directory for Update Client](CapabilityStatement-nl-gf-admin-directory-update-client.md) and [Query Directory for Query Client](CapabilityStatement-nl-gf-query-directory-query-client.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.nl.gf|current/StructureDefinition/nl-gf-organizationaffiliation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-organizationaffiliation.csv), [Excel](StructureDefinition-nl-gf-organizationaffiliation.xlsx), [Schematron](StructureDefinition-nl-gf-organizationaffiliation.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-organizationaffiliation",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organizationaffiliation",
  "version" : "0.2.0",
  "name" : "NlGfOrganizationAffiliation",
  "title" : "NL Generic Functions OrganizationAffiliation Profile",
  "status" : "draft",
  "date" : "2025-10-15T05:28:50+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "The details of an affiliation/relationship between two organizations, such as a healthcare provider and a software vendor.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "OrganizationAffiliation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/OrganizationAffiliation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "OrganizationAffiliation",
        "path" : "OrganizationAffiliation"
      },
      {
        "id" : "OrganizationAffiliation.implicitRules",
        "path" : "OrganizationAffiliation.implicitRules",
        "max" : "0"
      },
      {
        "id" : "OrganizationAffiliation.modifierExtension",
        "path" : "OrganizationAffiliation.modifierExtension",
        "max" : "0"
      },
      {
        "id" : "OrganizationAffiliation.active",
        "path" : "OrganizationAffiliation.active",
        "min" : 1
      },
      {
        "id" : "OrganizationAffiliation.organization",
        "path" : "OrganizationAffiliation.organization",
        "min" : 1
      },
      {
        "id" : "OrganizationAffiliation.participatingOrganization",
        "path" : "OrganizationAffiliation.participatingOrganization",
        "min" : 1
      },
      {
        "id" : "OrganizationAffiliation.code",
        "path" : "OrganizationAffiliation.code",
        "min" : 1
      }
    ]
  }
}

```
