# Bundle of care services in Query Directory - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle of care services in Query Directory**

## Example Bundle: Bundle of care services in Query Directory

Bundle query-directory of type transaction

-------

Entry 1 - fullUrl = urn:uuid:lrza-o1

Resource Organization:

> 

Information Source: [https://www.cibg.nl/lrza/fhirr4/Organization/3f39dca9-a392-4eb3-8366-0c7ff53ab3a9](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://www.cibg.nl/lrza/fhirr4/Organization/3f39dca9-a392-4eb3-8366-0c7ff53ab3a9)

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/11111111**type**:Huisartspraktijk (zelfstandig of groepspraktijk)**name**: example General Practice
> **contact****telecom**:[+3131599991](tel:+3131599991),[info@cp1.example.org](mailto:info@cp1.example.org)**address**: Vogelenzangweg 31 null null Ulft 7071 PT
**endpoint**:[Endpoint FHIR Endpoint 1](Bundle-query-directory.md#Endpoint_lrza-e1)

Request:

```
PUT Organization/lrza-o1

```

-------

Entry 2 - fullUrl = urn:uuid:lrza-e1

Resource Endpoint:

> 

Information Source: [https://www.cibg.nl/lrza/fhirr4/Endpoint/ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://www.cibg.nl/lrza/fhirr4/Endpoint/ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4)

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**status**: Active**connectionType**:HL7 FHIR**name**: FHIR Endpoint 1**managingOrganization**: Identifier:`http://fhir.nl/fhir/NamingSystem/kvk`/51494752**contact**:[+3131599991](tel:+3131599991),[info@cp1.example.org](mailto:info@cp1.example.org)**address**:[https://cp1-test.example.org/fhirr4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp1-test.example.org/fhirr4)

Request:

```
PUT Endpoint/lrza-e1

```

-------

Entry 3 - fullUrl = urn:uuid:lrza-o2

Resource Organization:

> 

Information Source: [https://www.cibg.nl/lrza/fhirr4/Organization/4815bbe6-9fea-4875-a16c-a168d63054d4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://www.cibg.nl/lrza/fhirr4/Organization/4815bbe6-9fea-4875-a16c-a168d63054d4)

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/22222222**type**:Ziekenhuis,Hospital**name**: example Hospital
> **contact****telecom**:[+31301234567](tel:+31301234567),[info@cp2.example.org](mailto:info@cp2.example.org)**address**: Catharinastraat 21 Doetinchem 7001 BZ
**endpoint**:[Endpoint FHIR Endpoint 2](Bundle-query-directory.md#Endpoint_lrza-e2)

Request:

```
PUT Organization/lrza-o2

```

-------

Entry 4 - fullUrl = urn:uuid:lrza-e2

Resource Endpoint:

> 

Information Source: [https://www.cibg.nl/lrza/fhirr4/Endpoint/960a4f8c-74d8-482c-97ab-e2a025869fee](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://www.cibg.nl/lrza/fhirr4/Endpoint/960a4f8c-74d8-482c-97ab-e2a025869fee)

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**status**: Active**connectionType**:HL7 FHIR**name**: FHIR Endpoint 2**managingOrganization**: Identifier:`http://fhir.nl/fhir/NamingSystem/kvk`/08013836**contact**:[+3131599991](tel:+3131599991),[info@nedap.example.org](mailto:info@nedap.example.org)**address**:[https://cp2-test.example.org/fhirr4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4)

Request:

```
PUT Endpoint/lrza-e2

```

-------

Entry 5 - fullUrl = urn:uuid:lrza-o3

Resource Organization:

> 

Information Source: [https://www.cibg.nl/lrza/fhirr4/Organization/fcf55b06-f22c-4058-9051-b77368bdd26b](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://www.cibg.nl/lrza/fhirr4/Organization/fcf55b06-f22c-4058-9051-b77368bdd26b)

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/33333333**type**:Verplegings- of verzorgingsinstelling**name**: example Care Institution
> **contact****telecom**:[+31301234567](tel:+31301234567),[info@organization3.nl](mailto:info@organization3.nl)**address**: Smidsstraat 10 Zelhem 7021 AC
**endpoint**:[Endpoint FHIR Endpoint 3](Bundle-query-directory.md#Endpoint_lrza-e3)

Request:

```
PUT Organization/lrza-o3

```

-------

Entry 6 - fullUrl = urn:uuid:lrza-e3

Resource Endpoint:

> 

Information Source: [https://www.cibg.nl/lrza/fhirr4/Endpoint/553416dd-da12-40f7-a9bd-eb3e193177bd](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://www.cibg.nl/lrza/fhirr4/Endpoint/553416dd-da12-40f7-a9bd-eb3e193177bd)

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**status**: Active**connectionType**:HL7 FHIR**name**: FHIR Endpoint 3**managingOrganization**: Identifier:`http://fhir.nl/fhir/NamingSystem/kvk`/34270859**contact**:[+3131599991](tel:+3131599991),[info@example.org](mailto:info@example.org)**address**:[https://cp3-test.example.org/fhirr4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp3-test.example.org/fhirr4)

Request:

```
PUT Endpoint/lrza-e3

```

-------

Entry 7 - fullUrl = urn:uuid:ad1-o1

Resource Organization:

> 

Information Source: [https://cp1-test.example.org/fhirr4/Organization/4cb35b96-f021-4e15-bf71-d67a6d4bebec](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp1-test.example.org/fhirr4/Organization/4cb35b96-f021-4e15-bf71-d67a6d4bebec)

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/11111111**type**:Huisartspraktijk (zelfstandig of groepspraktijk)**name**: example General Practice
> **contact****telecom**:[+3131599991](tel:+3131599991),[info@cp1.example.org](mailto:info@cp1.example.org)**address**: Vogelenzangweg 31 null null Ulft 7071 PT
**endpoint**:[Endpoint FHIR Endpoint 1](Bundle-query-directory.md#Endpoint_ad1-e1)

Request:

```
PUT Organization/ad1-o1

```

-------

Entry 8 - fullUrl = urn:uuid:ad1-e1

Resource Endpoint:

> 

Information Source: [https://cp1-test.example.org/fhirr4/Endpoint/59654248-477c-4694-b156-e0042f0765a6](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp1-test.example.org/fhirr4/Endpoint/59654248-477c-4694-b156-e0042f0765a6)

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**status**: Active**connectionType**:HL7 FHIR**name**: FHIR Endpoint 1**managingOrganization**: Identifier:`http://fhir.nl/fhir/NamingSystem/kvk`/51494752**contact**:[+3131599991](tel:+3131599991),[info@cp1.example.org](mailto:info@cp1.example.org)**address**:[https://cp1-test.example.org/fhirr4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp1-test.example.org/fhirr4)

Request:

```
PUT Endpoint/ad1-e1

```

-------

Entry 9 - fullUrl = urn:uuid:ad1-pr1

Resource PractitionerRole:

> 

Information Source: [https://cp1-test.example.org/fhirr4/PractitionerRole/5fa4c91a-a12f-48ae-a4c7-92971dc7ab53](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp1-test.example.org/fhirr4/PractitionerRole/5fa4c91a-a12f-48ae-a4c7-92971dc7ab53)

Profile: [NL Generic Functions PractitionerRole Profile](StructureDefinition-nl-gf-practitionerrole.md)

**identifier**:`http://cp1.example.org/HRM/assignments`/654321,`http://fhir.nl/fhir/NamingSystem/uzi`/UZI-2**practitioner**:[Practitioner Hary Arts(official)](Bundle-query-directory.md#Practitioner_ad1-p1)**organization**:[Organization example General Practice](Bundle-query-directory.md#Organization_ad1-o1)**code**:Huisarts

Request:

```
PUT PractitionerRole/ad1-pr1

```

-------

Entry 10 - fullUrl = urn:uuid:ad1-p1

Resource Practitioner:

> 

Information Source: [https://cp1-test.example.org/fhirr4/Practitioner/9a63e407-34af-4ae4-ad3c-f7107fbbc0cd](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp1-test.example.org/fhirr4/Practitioner/9a63e407-34af-4ae4-ad3c-f7107fbbc0cd)

Profile: [NL Generic Functions Practitioner Profile](StructureDefinition-nl-gf-practitioner.md)

**identifier**:`http://cp1.example.org/HRM/employees`/5678**name**: Hary Arts(Official)

Request:

```
PUT Practitioner/ad1-p1

```

-------

Entry 11 - fullUrl = urn:uuid:ad2-o1

Resource Organization:

> 

Information Source: [https://cp2-test.example.org/fhirr4/Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4/Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067)

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/22222222**type**:Ziekenhuis,Hospital**name**: example Hospital
> **contact****telecom**:[+31301234567](tel:+31301234567),[info@cp2.example.org](mailto:info@cp2.example.org)**address**: Catharinastraat 21 Doetinchem 7001 BZ
**endpoint**:
* [Endpoint FHIR Endpoint 2](Bundle-query-directory.md#Endpoint_ad2-e1)
* [Endpoint DICOM-WADO-RS Endpoint](Bundle-query-directory.md#Endpoint_ad2-e2)

Request:

```
PUT Organization/ad2-o1

```

-------

Entry 12 - fullUrl = urn:uuid:ad2-e1

Resource Endpoint:

> 

Information Source: [https://cp2-test.example.org/fhirr4/Endpoint/430f7379-8ec2-4e55-b096-919995da61e2](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4/Endpoint/430f7379-8ec2-4e55-b096-919995da61e2)

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**status**: Active**connectionType**:HL7 FHIR**name**: FHIR Endpoint 2**managingOrganization**: Identifier:`http://fhir.nl/fhir/NamingSystem/kvk`/08013836**contact**:[+3131599991](tel:+3131599991),[info@nedap.example.org](mailto:info@nedap.example.org)**address**:[https://cp2-test.example.org/fhirr4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4)

Request:

```
PUT Endpoint/ad2-e1

```

-------

Entry 13 - fullUrl = urn:uuid:ad2-e2

Resource Endpoint:

> 

Information Source: [https://cp2-test.example.org/fhirr4/Endpoint/d4c1d657-67a9-471c-9732-9c042e9a6d43](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4/Endpoint/d4c1d657-67a9-471c-9732-9c042e9a6d43)

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**status**: Active**connectionType**:DICOM WADO-RS**name**: DICOM-WADO-RS Endpoint**managingOrganization**: Identifier:`http://fhir.nl/fhir/NamingSystem/kvk`/08013836**contact**:[+3131599991](tel:+3131599991),[info@nedap.example.org](mailto:info@nedap.example.org)**address**:[https://cp2-test.example.org/dicom-wado-rs](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/dicom-wado-rs)

Request:

```
PUT Endpoint/ad2-e2

```

-------

Entry 14 - fullUrl = urn:uuid:ad2-e3

Resource Endpoint:

> 

Information Source: [https://cp2-test.example.org/fhirr4/Endpoint/2427ca0c-8a29-4a6a-aabd-50cf02f587a7](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4/Endpoint/2427ca0c-8a29-4a6a-aabd-50cf02f587a7)

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**status**: Active**connectionType**:HL7 FHIR**name**: FHIR STU3 Endpoint**managingOrganization**: Identifier:`http://fhir.nl/fhir/NamingSystem/kvk`/08013836**contact**:[+3131599991](tel:+3131599991),[info@nedap.example.org](mailto:info@nedap.example.org)**address**:[https://cp2-test.example.org/fhirstu3](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirstu3)

Request:

```
PUT Endpoint/ad2-e3

```

-------

Entry 15 - fullUrl = urn:uuid:ad2-hs1

Resource HealthcareService:

> 

Information Source: [https://cp2-test.example.org/fhirr4/HealthcareService/5cb05355-474b-4d30-8b0e-a9ca574b8274](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4/HealthcareService/5cb05355-474b-4d30-8b0e-a9ca574b8274)

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**active**: true**providedBy**:[Organization example Hospital](Bundle-query-directory.md#Organization_ad2-o1)**type**:Consultation**specialty**:Chirurgie (Heelkunde),Chirurg**name**: Polikliniek 't Vaatje

Request:

```
PUT HealthcareService/ad2-hs1

```

-------

Entry 16 - fullUrl = urn:uuid:ad2-hs2

Resource HealthcareService:

> 

Information Source: [https://cp2-test.example.org/fhirr4/HealthcareService/c79125e5-739f-4238-959c-cd5872518c1f](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4/HealthcareService/c79125e5-739f-4238-959c-cd5872518c1f)

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**active**: true**providedBy**:[Organization example Hospital](Bundle-query-directory.md#Organization_ad2-o1)**type**:Consultation**specialty**:Medisch specialisten, neurochirurgie,Neurochirurg**name**: Neurochirurgie

Request:

```
PUT HealthcareService/ad2-hs2

```

-------

Entry 17 - fullUrl = urn:uuid:ad2-hs3

Resource HealthcareService:

> 

Information Source: [https://cp2-test.example.org/fhirr4/HealthcareService/9d47ca45-4166-4531-a23d-ef5fa613ece4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4/HealthcareService/9d47ca45-4166-4531-a23d-ef5fa613ece4)

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**active**: true**providedBy**:[Organization example Hospital](Bundle-query-directory.md#Organization_ad2-o1)**type**:Consultation**specialty**:Medisch specialisten, orthopedie,Orthopedisch chirurg**name**: Orthopedie

Request:

```
PUT HealthcareService/ad2-hs3

```

-------

Entry 18 - fullUrl = urn:uuid:ad2-hs4

Resource HealthcareService:

> 

Information Source: [https://cp2-test.example.org/fhirr4/HealthcareService/f6a508bd-9455-4afa-aad0-baec0833602d](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4/HealthcareService/f6a508bd-9455-4afa-aad0-baec0833602d)

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**active**: true**providedBy**:[Organization example Hospital](Bundle-query-directory.md#Organization_ad2-o1)**type**:Consultation**specialty**:Interne geneeskunde,Internist**name**: Interne Geneeskunde

Request:

```
PUT HealthcareService/ad2-hs4

```

-------

Entry 19 - fullUrl = urn:uuid:ad2-hs5

Resource HealthcareService:

> 

Information Source: [https://cp2-test.example.org/fhirr4/HealthcareService/120325af-083c-40ee-b16e-01230fe65655](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4/HealthcareService/120325af-083c-40ee-b16e-01230fe65655)

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**active**: true**providedBy**:[Organization example Hospital](Bundle-query-directory.md#Organization_ad2-o1)**type**:Consultation**specialty**:Medisch specialisten, geriatrie,Klinisch geriater**name**: Geriatrie

Request:

```
PUT HealthcareService/ad2-hs5

```

-------

Entry 20 - fullUrl = urn:uuid:ad2-hs6

Resource HealthcareService:

> 

Information Source: [https://cp2-test.example.org/fhirr4/HealthcareService/08013141-16b2-42a0-8c9a-af57cee5511b](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4/HealthcareService/08013141-16b2-42a0-8c9a-af57cee5511b)

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**active**: true**providedBy**:[Organization example Hospital](Bundle-query-directory.md#Organization_ad2-o1)**type**:Consultation**specialty**:Medisch specialisten, urologie,Uroloog**name**: Urologie

Request:

```
PUT HealthcareService/ad2-hs6

```

-------

Entry 21 - fullUrl = urn:uuid:ad2-pr1

Resource PractitionerRole:

> 

Information Source: [https://cp2-test.example.org/fhirr4/PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4/PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba)

Profile: [NL Generic Functions PractitionerRole Profile](StructureDefinition-nl-gf-practitionerrole.md)

**identifier**:`http://cp2.example.org/HRM/assignments`/123456,`http://fhir.nl/fhir/NamingSystem/uzi`/UZI-1**practitioner**:[Practitioner Caroline van Dijk(official)](Bundle-query-directory.md#Practitioner_ad2-p1)**organization**:[Organization example Hospital](Bundle-query-directory.md#Organization_ad2-o1)**code**:Cardioloog**specialty**:Cardioloog

Request:

```
PUT PractitionerRole/ad2-pr1

```

-------

Entry 22 - fullUrl = urn:uuid:ad2-p1

Resource Practitioner:

> 

Information Source: [https://cp2-test.example.org/fhirr4/Practitioner/040b160a-6072-4244-adc0-2b786c4ef052](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4/Practitioner/040b160a-6072-4244-adc0-2b786c4ef052)

Profile: [NL Generic Functions Practitioner Profile](StructureDefinition-nl-gf-practitioner.md)

**identifier**:`http://cp2.example.org/HRM/employees`/1234**name**: Caroline van Dijk(Official)

Request:

```
PUT Practitioner/ad2-p1

```

-------

Entry 23 - fullUrl = urn:uuid:ad3-o1

Resource Organization:

> 

Information Source: [https://cp3-test.example.org/fhirr4/Organization/3e799075-63a2-4a4c-913d-a91b8198463d](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp3-test.example.org/fhirr4/Organization/3e799075-63a2-4a4c-913d-a91b8198463d)

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/33333333**type**:Verplegings- of verzorgingsinstelling**name**: example Care Institution
> **contact****telecom**:[+31301234567](tel:+31301234567),[info@organization3.nl](mailto:info@organization3.nl)**address**: Smidsstraat 10 Zelhem 7021 AC
**endpoint**:[Endpoint FHIR R4 Endpoint](Bundle-query-directory.md#Endpoint_ad3-e1)

Request:

```
PUT Organization/ad3-o1

```

-------

Entry 24 - fullUrl = urn:uuid:ad3-o2

Resource Organization:

> 

Information Source: [https://cp3-test.example.org/fhirr4/Organization/631cf10e-42d6-4165-9907-11e2333d4a85](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp3-test.example.org/fhirr4/Organization/631cf10e-42d6-4165-9907-11e2333d4a85)

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**type**:Verplegings- of verzorgingsinstelling**name**: Nursing department at Organization 3**partOf**:[Organization example Care Institution](Bundle-query-directory.md#Organization_ad3-o1)

Request:

```
PUT Organization/ad3-o2

```

-------

Entry 25 - fullUrl = urn:uuid:ad3-e1

Resource Endpoint:

> 

Information Source: [https://cp3-test.example.org/fhirr4/Endpoint/8f224548-6d50-44b6-82c5-75826ee0900f](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp3-test.example.org/fhirr4/Endpoint/8f224548-6d50-44b6-82c5-75826ee0900f)

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**status**: Active**connectionType**:HL7 FHIR**name**: FHIR R4 Endpoint**managingOrganization**: Identifier:`http://fhir.nl/fhir/NamingSystem/kvk`/34270859**contact**:[+3131599991](tel:+3131599991),[info@example.org](mailto:info@example.org)**address**:[https://cp3-test.example.org/fhirr4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp3-test.example.org/fhirr4)

Request:

```
PUT Endpoint/ad3-e1

```

-------

Entry 26 - fullUrl = urn:uuid:ad3-e2

Resource Endpoint:

> 

Information Source: [https://cp3-test.example.org/fhirr4/Endpoint/72a349cc-7336-4a91-873d-fc9349769e1a](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp3-test.example.org/fhirr4/Endpoint/72a349cc-7336-4a91-873d-fc9349769e1a)

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**status**: Active**connectionType**:HL7 FHIR**name**: FHIR STU3 Endpoint**managingOrganization**: Identifier:`http://fhir.nl/fhir/NamingSystem/kvk`/34270859**contact**:[+3131599991](tel:+3131599991),[info@example.org](mailto:info@example.org)**address**:[https://cp3-test.example.org/fhirstu3](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp3-test.example.org/fhirstu3)

Request:

```
PUT Endpoint/ad3-e2

```

-------

Entry 27 - fullUrl = urn:uuid:ad3-hs1

Resource HealthcareService:

> 

Information Source: [https://cp3-test.example.org/fhirr4/HealthcareService/4fcf98c7-b198-4d61-8b3e-5ea39e33c405](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp3-test.example.org/fhirr4/HealthcareService/4fcf98c7-b198-4d61-8b3e-5ea39e33c405)

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**active**: true**providedBy**:[Organization example Care Institution](Bundle-query-directory.md#Organization_ad3-o1)**type**:Brief comprehensive geriatric assessment,comprehensive geriatric assessment,Visual field study**specialty**:Medisch specialisten, geriatrie**name**: Geriatrie

Request:

```
PUT HealthcareService/ad3-hs1

```

-------

Entry 28 - fullUrl = urn:uuid:ad3-hs2

Resource HealthcareService:

> 

Information Source: [https://cp3-test.example.org/fhirr4/HealthcareService/b48826dc-2d58-479a-bfd3-80b7a9d69757](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp3-test.example.org/fhirr4/HealthcareService/b48826dc-2d58-479a-bfd3-80b7a9d69757)

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**active**: true**providedBy**:[Organization Nursing department at Organization 3](Bundle-query-directory.md#Organization_ad3-o2)**type**:Patient transfer to skilled nursing facility for level 1 care,Patient transfer to skilled nursing facility for level 2 care,Patient transfer to skilled nursing facility for level 3 care**specialty**:Verpleegkundige**name**: Verpleging

Request:

```
PUT HealthcareService/ad3-hs2

```

-------

Entry 29 - fullUrl = urn:uuid:ad3-p1

Resource Practitioner:

> 

Information Source: [https://cp3-test.example.org/fhirr4/Practitioner/08630c28-5e2a-4b0c-b8ce-f08f533246b9](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp3-test.example.org/fhirr4/Practitioner/08630c28-5e2a-4b0c-b8ce-f08f533246b9)

Profile: [NL Generic Functions Practitioner Profile](StructureDefinition-nl-gf-practitioner.md)

**active**: true**name**: John Doe**telecom**:[+31301234568](tel:+31301234568),**address**: Smidsstraat 11 Zelhem 7021 AC

Request:

```
PUT Practitioner/ad3-p1

```

-------

Entry 30 - fullUrl = urn:uuid:ad3-pr1

Resource PractitionerRole:

> 

Information Source: [https://cp3-test.example.org/fhirr4/PractitionerRole/d60525bd-5caf-4437-8f4b-4156300a27de](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp3-test.example.org/fhirr4/PractitionerRole/d60525bd-5caf-4437-8f4b-4156300a27de)

Profile: [NL Generic Functions PractitionerRole Profile](StructureDefinition-nl-gf-practitionerrole.md)

**active**: true**practitioner**:[Practitioner John Doe](Bundle-query-directory.md#Practitioner_ad3-p1)**organization**:[Organization example Care Institution](Bundle-query-directory.md#Organization_ad3-o1)**code**:Klinisch geriater**specialty**:Medisch specialisten, geriatrie,Klinisch geriater

Request:

```
PUT PractitionerRole/ad3-pr1

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "query-directory",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:lrza-o1",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "lrza-o1",
        "meta" : {
          "source" : "https://www.cibg.nl/lrza/fhirr4/Organization/3f39dca9-a392-4eb3-8366-0c7ff53ab3a9",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_lrza-o1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization lrza-o1</b></p><a name=\"lrza-o1\"> </a><a name=\"hclrza-o1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://www.cibg.nl/lrza/fhirr4/Organization/3f39dca9-a392-4eb3-8366-0c7ff53ab3a9\">https://www.cibg.nl/lrza/fhirr4/Organization/3f39dca9-a392-4eb3-8366-0c7ff53ab3a9</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-organization.html\">NL Generic Functions Organization Profile</a></p></div><p><b>identifier</b>: Ura/11111111</p><p><b>type</b>: <span title=\"Codes:{http://nictiz.nl/fhir/NamingSystem/organization-type Z3}\">Huisartspraktijk (zelfstandig of groepspraktijk)</span></p><p><b>name</b>: example General Practice</p><p><b>telecom</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@cp1.example.org\">info@cp1.example.org</a></p><p><b>address</b>: Vogelenzangweg 31 null null Ulft 7071 PT </p><p><b>endpoint</b>: <a href=\"Bundle-query-directory.html#Endpoint_lrza-e1\">Endpoint FHIR Endpoint 1</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/ura",
            "value" : "11111111"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
                "code" : "Z3",
                "display" : "Huisartspraktijk (zelfstandig of groepspraktijk)"
              }
            ]
          }
        ],
        "name" : "example General Practice",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@cp1.example.org",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["Vogelenzangweg 31", null, null],
            "_line" : [
              null,
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "Vogelenzangweg"
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "31"
                  }
                ]
              }
            ],
            "city" : "Ulft",
            "postalCode" : "7071 PT"
          }
        ],
        "endpoint" : [
          {
            "reference" : "Endpoint/lrza-e1"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Organization/lrza-o1"
      }
    },
    {
      "fullUrl" : "urn:uuid:lrza-e1",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "lrza-e1",
        "meta" : {
          "source" : "https://www.cibg.nl/lrza/fhirr4/Endpoint/ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_lrza-e1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint lrza-e1</b></p><a name=\"lrza-e1\"> </a><a name=\"hclrza-e1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://www.cibg.nl/lrza/fhirr4/Endpoint/ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4\">https://www.cibg.nl/lrza/fhirr4/Endpoint/ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type hl7-fhir-rest</a>: HL7 FHIR</p><p><b>name</b>: FHIR Endpoint 1</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/51494752</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@cp1.example.org\">info@cp1.example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client}\">Care Services Directory for Update Client</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp1-test.example.org/fhirr4\">https://cp1-test.example.org/fhirr4</a></p></div>"
        },
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR Endpoint 1",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "51494752"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@cp1.example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client",
                "display" : "Care Services Directory for Update Client"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp1-test.example.org/fhirr4"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/lrza-e1"
      }
    },
    {
      "fullUrl" : "urn:uuid:lrza-o2",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "lrza-o2",
        "meta" : {
          "source" : "https://www.cibg.nl/lrza/fhirr4/Organization/4815bbe6-9fea-4875-a16c-a168d63054d4",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_lrza-o2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization lrza-o2</b></p><a name=\"lrza-o2\"> </a><a name=\"hclrza-o2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://www.cibg.nl/lrza/fhirr4/Organization/4815bbe6-9fea-4875-a16c-a168d63054d4\">https://www.cibg.nl/lrza/fhirr4/Organization/4815bbe6-9fea-4875-a16c-a168d63054d4</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-organization.html\">NL Generic Functions Organization Profile</a></p></div><p><b>identifier</b>: Ura/22222222</p><p><b>type</b>: <span title=\"Codes:{http://nictiz.nl/fhir/NamingSystem/organization-type V4}\">Ziekenhuis</span>, <span title=\"Codes:{http://snomed.info/sct 22232009}\">Hospital</span></p><p><b>name</b>: example Hospital</p><p><b>telecom</b>: <a href=\"tel:+31301234567\">+31301234567</a>, <a href=\"mailto:info@cp2.example.org\">info@cp2.example.org</a></p><p><b>address</b>: Catharinastraat 21 Doetinchem 7001 BZ </p><p><b>endpoint</b>: <a href=\"Bundle-query-directory.html#Endpoint_lrza-e2\">Endpoint FHIR Endpoint 2</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/ura",
            "value" : "22222222"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
                "code" : "V4",
                "display" : "Ziekenhuis"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "22232009",
                "display" : "Hospital"
              }
            ]
          }
        ],
        "name" : "example Hospital",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31301234567",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@cp2.example.org",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["Catharinastraat 21"],
            "_line" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "Catharinastraat"
                  },
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "21"
                  }
                ]
              }
            ],
            "city" : "Doetinchem",
            "postalCode" : "7001 BZ"
          }
        ],
        "endpoint" : [
          {
            "reference" : "Endpoint/lrza-e2"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Organization/lrza-o2"
      }
    },
    {
      "fullUrl" : "urn:uuid:lrza-e2",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "lrza-e2",
        "meta" : {
          "source" : "https://www.cibg.nl/lrza/fhirr4/Endpoint/960a4f8c-74d8-482c-97ab-e2a025869fee",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_lrza-e2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint lrza-e2</b></p><a name=\"lrza-e2\"> </a><a name=\"hclrza-e2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://www.cibg.nl/lrza/fhirr4/Endpoint/960a4f8c-74d8-482c-97ab-e2a025869fee\">https://www.cibg.nl/lrza/fhirr4/Endpoint/960a4f8c-74d8-482c-97ab-e2a025869fee</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type hl7-fhir-rest</a>: HL7 FHIR</p><p><b>name</b>: FHIR Endpoint 2</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/08013836</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@nedap.example.org\">info@nedap.example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client}\">Care Services Directory for Update Client</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4\">https://cp2-test.example.org/fhirr4</a></p></div>"
        },
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR Endpoint 2",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "08013836"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@nedap.example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client",
                "display" : "Care Services Directory for Update Client"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp2-test.example.org/fhirr4"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/lrza-e2"
      }
    },
    {
      "fullUrl" : "urn:uuid:lrza-o3",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "lrza-o3",
        "meta" : {
          "source" : "https://www.cibg.nl/lrza/fhirr4/Organization/fcf55b06-f22c-4058-9051-b77368bdd26b",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_lrza-o3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization lrza-o3</b></p><a name=\"lrza-o3\"> </a><a name=\"hclrza-o3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://www.cibg.nl/lrza/fhirr4/Organization/fcf55b06-f22c-4058-9051-b77368bdd26b\">https://www.cibg.nl/lrza/fhirr4/Organization/fcf55b06-f22c-4058-9051-b77368bdd26b</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-organization.html\">NL Generic Functions Organization Profile</a></p></div><p><b>identifier</b>: Ura/33333333</p><p><b>type</b>: <span title=\"Codes:{http://nictiz.nl/fhir/NamingSystem/organization-type X3}\">Verplegings- of verzorgingsinstelling</span></p><p><b>name</b>: example Care Institution</p><p><b>telecom</b>: <a href=\"tel:+31301234567\">+31301234567</a>, <a href=\"mailto:info@organization3.nl\">info@organization3.nl</a></p><p><b>address</b>: Smidsstraat 10 Zelhem 7021 AC </p><p><b>endpoint</b>: <a href=\"Bundle-query-directory.html#Endpoint_lrza-e3\">Endpoint FHIR Endpoint 3</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/ura",
            "value" : "33333333"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
                "code" : "X3",
                "display" : "Verplegings- of verzorgingsinstelling"
              }
            ]
          }
        ],
        "name" : "example Care Institution",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31301234567",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@organization3.nl",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["Smidsstraat 10"],
            "_line" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "Smidsstraat"
                  },
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "10"
                  }
                ]
              }
            ],
            "city" : "Zelhem",
            "postalCode" : "7021 AC"
          }
        ],
        "endpoint" : [
          {
            "reference" : "Endpoint/lrza-e3"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Organization/lrza-o3"
      }
    },
    {
      "fullUrl" : "urn:uuid:lrza-e3",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "lrza-e3",
        "meta" : {
          "source" : "https://www.cibg.nl/lrza/fhirr4/Endpoint/553416dd-da12-40f7-a9bd-eb3e193177bd",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_lrza-e3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint lrza-e3</b></p><a name=\"lrza-e3\"> </a><a name=\"hclrza-e3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://www.cibg.nl/lrza/fhirr4/Endpoint/553416dd-da12-40f7-a9bd-eb3e193177bd\">https://www.cibg.nl/lrza/fhirr4/Endpoint/553416dd-da12-40f7-a9bd-eb3e193177bd</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type hl7-fhir-rest</a>: HL7 FHIR</p><p><b>name</b>: FHIR Endpoint 3</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/34270859</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@example.org\">info@example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client}\">Care Services Directory for Update Client</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp3-test.example.org/fhirr4\">https://cp3-test.example.org/fhirr4</a></p></div>"
        },
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR Endpoint 3",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "34270859"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client",
                "display" : "Care Services Directory for Update Client"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp3-test.example.org/fhirr4"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/lrza-e3"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad1-o1",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "ad1-o1",
        "meta" : {
          "source" : "https://cp1-test.example.org/fhirr4/Organization/4cb35b96-f021-4e15-bf71-d67a6d4bebec",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_ad1-o1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization ad1-o1</b></p><a name=\"ad1-o1\"> </a><a name=\"hcad1-o1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp1-test.example.org/fhirr4/Organization/4cb35b96-f021-4e15-bf71-d67a6d4bebec\">https://cp1-test.example.org/fhirr4/Organization/4cb35b96-f021-4e15-bf71-d67a6d4bebec</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-organization.html\">NL Generic Functions Organization Profile</a></p></div><p><b>identifier</b>: Ura/11111111</p><p><b>type</b>: <span title=\"Codes:{http://nictiz.nl/fhir/NamingSystem/organization-type Z3}\">Huisartspraktijk (zelfstandig of groepspraktijk)</span></p><p><b>name</b>: example General Practice</p><p><b>telecom</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@cp1.example.org\">info@cp1.example.org</a></p><p><b>address</b>: Vogelenzangweg 31 null null Ulft 7071 PT </p><p><b>endpoint</b>: <a href=\"Bundle-query-directory.html#Endpoint_ad1-e1\">Endpoint FHIR Endpoint 1</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/ura",
            "value" : "11111111"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
                "code" : "Z3",
                "display" : "Huisartspraktijk (zelfstandig of groepspraktijk)"
              }
            ]
          }
        ],
        "name" : "example General Practice",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@cp1.example.org",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["Vogelenzangweg 31", null, null],
            "_line" : [
              null,
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "Vogelenzangweg"
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "31"
                  }
                ]
              }
            ],
            "city" : "Ulft",
            "postalCode" : "7071 PT"
          }
        ],
        "endpoint" : [
          {
            "reference" : "Endpoint/ad1-e1"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Organization/ad1-o1"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad1-e1",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "ad1-e1",
        "meta" : {
          "source" : "https://cp1-test.example.org/fhirr4/Endpoint/59654248-477c-4694-b156-e0042f0765a6",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_ad1-e1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint ad1-e1</b></p><a name=\"ad1-e1\"> </a><a name=\"hcad1-e1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp1-test.example.org/fhirr4/Endpoint/59654248-477c-4694-b156-e0042f0765a6\">https://cp1-test.example.org/fhirr4/Endpoint/59654248-477c-4694-b156-e0042f0765a6</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type hl7-fhir-rest</a>: HL7 FHIR</p><p><b>name</b>: FHIR Endpoint 1</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/51494752</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@cp1.example.org\">info@cp1.example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client}\">Care Services Directory for Update Client</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp1-test.example.org/fhirr4\">https://cp1-test.example.org/fhirr4</a></p></div>"
        },
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR Endpoint 1",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "51494752"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@cp1.example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client",
                "display" : "Care Services Directory for Update Client"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp1-test.example.org/fhirr4"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/ad1-e1"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad1-pr1",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "ad1-pr1",
        "meta" : {
          "source" : "https://cp1-test.example.org/fhirr4/PractitionerRole/5fa4c91a-a12f-48ae-a4c7-92971dc7ab53",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitionerrole"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_ad1-pr1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole ad1-pr1</b></p><a name=\"ad1-pr1\"> </a><a name=\"hcad1-pr1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp1-test.example.org/fhirr4/PractitionerRole/5fa4c91a-a12f-48ae-a4c7-92971dc7ab53\">https://cp1-test.example.org/fhirr4/PractitionerRole/5fa4c91a-a12f-48ae-a4c7-92971dc7ab53</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-practitionerrole.html\">NL Generic Functions PractitionerRole Profile</a></p></div><p><b>identifier</b>: <code>http://cp1.example.org/HRM/assignments</code>/654321, <code>http://fhir.nl/fhir/NamingSystem/uzi</code>/UZI-2</p><p><b>practitioner</b>: <a href=\"Bundle-query-directory.html#Practitioner_ad1-p1\">Practitioner Hary Arts(official)</a></p><p><b>organization</b>: <a href=\"Bundle-query-directory.html#Organization_ad1-o1\">Organization example General Practice</a></p><p><b>code</b>: <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.015}\">Huisarts</span></p><p><b>telecom</b>: <a href=\"mailto:h.arts@cp1.example.org\">h.arts@cp1.example.org</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://cp1.example.org/HRM/assignments",
            "value" : "654321"
          },
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/uzi",
            "value" : "UZI-2"
          }
        ],
        "practitioner" : {
          "reference" : "Practitioner/ad1-p1"
        },
        "organization" : {
          "reference" : "Organization/ad1-o1"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.015",
                "display" : "Huisarts"
              }
            ]
          }
        ],
        "telecom" : [
          {
            "system" : "email",
            "value" : "h.arts@cp1.example.org"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "PractitionerRole/ad1-pr1"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad1-p1",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "ad1-p1",
        "meta" : {
          "source" : "https://cp1-test.example.org/fhirr4/Practitioner/9a63e407-34af-4ae4-ad3c-f7107fbbc0cd",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_ad1-p1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner ad1-p1</b></p><a name=\"ad1-p1\"> </a><a name=\"hcad1-p1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp1-test.example.org/fhirr4/Practitioner/9a63e407-34af-4ae4-ad3c-f7107fbbc0cd\">https://cp1-test.example.org/fhirr4/Practitioner/9a63e407-34af-4ae4-ad3c-f7107fbbc0cd</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-practitioner.html\">NL Generic Functions Practitioner Profile</a></p></div><p><b>identifier</b>: <code>http://cp1.example.org/HRM/employees</code>/5678</p><p><b>name</b>: Hary Arts(Official)</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://cp1.example.org/HRM/employees",
            "value" : "5678"
          }
        ],
        "name" : [
          {
            "use" : "official",
            "text" : "Hary Arts",
            "family" : "Arts",
            "given" : ["Harry"]
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Practitioner/ad1-p1"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad2-o1",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "ad2-o1",
        "meta" : {
          "source" : "https://cp2-test.example.org/fhirr4/Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_ad2-o1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization ad2-o1</b></p><a name=\"ad2-o1\"> </a><a name=\"hcad2-o1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4/Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067\">https://cp2-test.example.org/fhirr4/Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-organization.html\">NL Generic Functions Organization Profile</a></p></div><p><b>identifier</b>: Ura/22222222</p><p><b>type</b>: <span title=\"Codes:{http://nictiz.nl/fhir/NamingSystem/organization-type V4}\">Ziekenhuis</span>, <span title=\"Codes:{http://snomed.info/sct 22232009}\">Hospital</span></p><p><b>name</b>: example Hospital</p><p><b>telecom</b>: <a href=\"tel:+31301234567\">+31301234567</a>, <a href=\"mailto:info@cp2.example.org\">info@cp2.example.org</a></p><p><b>address</b>: Catharinastraat 21 Doetinchem 7001 BZ </p><p><b>endpoint</b>: </p><ul><li><a href=\"Bundle-query-directory.html#Endpoint_ad2-e1\">Endpoint FHIR Endpoint 2</a></li><li><a href=\"Bundle-query-directory.html#Endpoint_ad2-e2\">Endpoint DICOM-WADO-RS Endpoint</a></li></ul></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/ura",
            "value" : "22222222"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
                "code" : "V4",
                "display" : "Ziekenhuis"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "22232009",
                "display" : "Hospital"
              }
            ]
          }
        ],
        "name" : "example Hospital",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31301234567",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@cp2.example.org",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["Catharinastraat 21"],
            "_line" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "Catharinastraat"
                  },
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "21"
                  }
                ]
              }
            ],
            "city" : "Doetinchem",
            "postalCode" : "7001 BZ"
          }
        ],
        "endpoint" : [
          {
            "reference" : "Endpoint/ad2-e1"
          },
          {
            "reference" : "Endpoint/ad2-e2"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Organization/ad2-o1"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad2-e1",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "ad2-e1",
        "meta" : {
          "source" : "https://cp2-test.example.org/fhirr4/Endpoint/430f7379-8ec2-4e55-b096-919995da61e2",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_ad2-e1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint ad2-e1</b></p><a name=\"ad2-e1\"> </a><a name=\"hcad2-e1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4/Endpoint/430f7379-8ec2-4e55-b096-919995da61e2\">https://cp2-test.example.org/fhirr4/Endpoint/430f7379-8ec2-4e55-b096-919995da61e2</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type hl7-fhir-rest</a>: HL7 FHIR</p><p><b>name</b>: FHIR Endpoint 2</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/08013836</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@nedap.example.org\">info@nedap.example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client}\">Care Services Directory for Update Client</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4\">https://cp2-test.example.org/fhirr4</a></p></div>"
        },
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR Endpoint 2",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "08013836"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@nedap.example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client",
                "display" : "Care Services Directory for Update Client"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp2-test.example.org/fhirr4"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/ad2-e1"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad2-e2",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "ad2-e2",
        "meta" : {
          "source" : "https://cp2-test.example.org/fhirr4/Endpoint/d4c1d657-67a9-471c-9732-9c042e9a6d43",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_ad2-e2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint ad2-e2</b></p><a name=\"ad2-e2\"> </a><a name=\"hcad2-e2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4/Endpoint/d4c1d657-67a9-471c-9732-9c042e9a6d43\">https://cp2-test.example.org/fhirr4/Endpoint/d4c1d657-67a9-471c-9732-9c042e9a6d43</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-dicom-wado-rs\">Endpoint Connection Type dicom-wado-rs</a>: DICOM WADO-RS</p><p><b>name</b>: DICOM-WADO-RS Endpoint</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/08013836</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@nedap.example.org\">info@nedap.example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/endpoint-payload-type any}\">Any</span></p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/dicom-wado-rs\">https://cp2-test.example.org/dicom-wado-rs</a></p></div>"
        },
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "dicom-wado-rs"
        },
        "name" : "DICOM-WADO-RS Endpoint",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "08013836"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@nedap.example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/endpoint-payload-type",
                "code" : "any",
                "display" : "Any"
              }
            ]
          }
        ],
        "address" : "https://cp2-test.example.org/dicom-wado-rs"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/ad2-e2"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad2-e3",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "ad2-e3",
        "meta" : {
          "source" : "https://cp2-test.example.org/fhirr4/Endpoint/2427ca0c-8a29-4a6a-aabd-50cf02f587a7",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_ad2-e3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint ad2-e3</b></p><a name=\"ad2-e3\"> </a><a name=\"hcad2-e3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4/Endpoint/2427ca0c-8a29-4a6a-aabd-50cf02f587a7\">https://cp2-test.example.org/fhirr4/Endpoint/2427ca0c-8a29-4a6a-aabd-50cf02f587a7</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type hl7-fhir-rest</a>: HL7 FHIR</p><p><b>name</b>: FHIR STU3 Endpoint</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/08013836</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@nedap.example.org\">info@nedap.example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities http://nictiz.nl/fhir/CapabilityStatement/eOverdracht-servercapabilities}\">Transfer of Care - eOverdracht Server</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirstu3\">https://cp2-test.example.org/fhirstu3</a></p></div>"
        },
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR STU3 Endpoint",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "08013836"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@nedap.example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://nictiz.nl/fhir/CapabilityStatement/eOverdracht-servercapabilities",
                "display" : "Transfer of Care - eOverdracht Server"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp2-test.example.org/fhirstu3"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/ad2-e3"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad2-hs1",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "ad2-hs1",
        "meta" : {
          "source" : "https://cp2-test.example.org/fhirr4/HealthcareService/5cb05355-474b-4d30-8b0e-a9ca574b8274",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_ad2-hs1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService ad2-hs1</b></p><a name=\"ad2-hs1\"> </a><a name=\"hcad2-hs1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4/HealthcareService/5cb05355-474b-4d30-8b0e-a9ca574b8274\">https://cp2-test.example.org/fhirr4/HealthcareService/5cb05355-474b-4d30-8b0e-a9ca574b8274</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Bundle-query-directory.html#Organization_ad2-o1\">Organization example Hospital</a></p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0303}\">Chirurgie (Heelkunde)</span>, <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.014}\">Chirurg</span></p><p><b>name</b>: Polikliniek 't Vaatje</p></div>"
        },
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/ad2-o1"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "11429006",
                "display" : "Consultation"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0303",
                "display" : "Chirurgie (Heelkunde)"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.014",
                "display" : "Chirurg"
              }
            ]
          }
        ],
        "name" : "Polikliniek 't Vaatje"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/ad2-hs1"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad2-hs2",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "ad2-hs2",
        "meta" : {
          "source" : "https://cp2-test.example.org/fhirr4/HealthcareService/c79125e5-739f-4238-959c-cd5872518c1f",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_ad2-hs2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService ad2-hs2</b></p><a name=\"ad2-hs2\"> </a><a name=\"hcad2-hs2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4/HealthcareService/c79125e5-739f-4238-959c-cd5872518c1f\">https://cp2-test.example.org/fhirr4/HealthcareService/c79125e5-739f-4238-959c-cd5872518c1f</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Bundle-query-directory.html#Organization_ad2-o1\">Organization example Hospital</a></p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0308}\">Medisch specialisten, neurochirurgie</span>, <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.025}\">Neurochirurg</span></p><p><b>name</b>: Neurochirurgie</p></div>"
        },
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/ad2-o1"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "11429006",
                "display" : "Consultation"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0308",
                "display" : "Medisch specialisten, neurochirurgie"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.025",
                "display" : "Neurochirurg"
              }
            ]
          }
        ],
        "name" : "Neurochirurgie"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/ad2-hs2"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad2-hs3",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "ad2-hs3",
        "meta" : {
          "source" : "https://cp2-test.example.org/fhirr4/HealthcareService/9d47ca45-4166-4531-a23d-ef5fa613ece4",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_ad2-hs3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService ad2-hs3</b></p><a name=\"ad2-hs3\"> </a><a name=\"hcad2-hs3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4/HealthcareService/9d47ca45-4166-4531-a23d-ef5fa613ece4\">https://cp2-test.example.org/fhirr4/HealthcareService/9d47ca45-4166-4531-a23d-ef5fa613ece4</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Bundle-query-directory.html#Organization_ad2-o1\">Organization example Hospital</a></p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0305}\">Medisch specialisten, orthopedie</span>, <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.032}\">Orthopedisch chirurg</span></p><p><b>name</b>: Orthopedie</p></div>"
        },
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/ad2-o1"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "11429006",
                "display" : "Consultation"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0305",
                "display" : "Medisch specialisten, orthopedie"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.032",
                "display" : "Orthopedisch chirurg"
              }
            ]
          }
        ],
        "name" : "Orthopedie"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/ad2-hs3"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad2-hs4",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "ad2-hs4",
        "meta" : {
          "source" : "https://cp2-test.example.org/fhirr4/HealthcareService/f6a508bd-9455-4afa-aad0-baec0833602d",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_ad2-hs4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService ad2-hs4</b></p><a name=\"ad2-hs4\"> </a><a name=\"hcad2-hs4\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4/HealthcareService/f6a508bd-9455-4afa-aad0-baec0833602d\">https://cp2-test.example.org/fhirr4/HealthcareService/f6a508bd-9455-4afa-aad0-baec0833602d</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Bundle-query-directory.html#Organization_ad2-o1\">Organization example Hospital</a></p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0313}\">Interne geneeskunde</span>, <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.016}\">Internist</span></p><p><b>name</b>: Interne Geneeskunde</p></div>"
        },
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/ad2-o1"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "11429006",
                "display" : "Consultation"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0313",
                "display" : "Interne geneeskunde"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.016",
                "display" : "Internist"
              }
            ]
          }
        ],
        "name" : "Interne Geneeskunde"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/ad2-hs4"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad2-hs5",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "ad2-hs5",
        "meta" : {
          "source" : "https://cp2-test.example.org/fhirr4/HealthcareService/120325af-083c-40ee-b16e-01230fe65655",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_ad2-hs5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService ad2-hs5</b></p><a name=\"ad2-hs5\"> </a><a name=\"hcad2-hs5\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4/HealthcareService/120325af-083c-40ee-b16e-01230fe65655\">https://cp2-test.example.org/fhirr4/HealthcareService/120325af-083c-40ee-b16e-01230fe65655</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Bundle-query-directory.html#Organization_ad2-o1\">Organization example Hospital</a></p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0335}\">Medisch specialisten, geriatrie</span>, <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.022}\">Klinisch geriater</span></p><p><b>name</b>: Geriatrie</p></div>"
        },
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/ad2-o1"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "11429006",
                "display" : "Consultation"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0335",
                "display" : "Medisch specialisten, geriatrie"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.022",
                "display" : "Klinisch geriater"
              }
            ]
          }
        ],
        "name" : "Geriatrie"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/ad2-hs5"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad2-hs6",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "ad2-hs6",
        "meta" : {
          "source" : "https://cp2-test.example.org/fhirr4/HealthcareService/08013141-16b2-42a0-8c9a-af57cee5511b",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_ad2-hs6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService ad2-hs6</b></p><a name=\"ad2-hs6\"> </a><a name=\"hcad2-hs6\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4/HealthcareService/08013141-16b2-42a0-8c9a-af57cee5511b\">https://cp2-test.example.org/fhirr4/HealthcareService/08013141-16b2-42a0-8c9a-af57cee5511b</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Bundle-query-directory.html#Organization_ad2-o1\">Organization example Hospital</a></p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0306}\">Medisch specialisten, urologie</span>, <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.045}\">Uroloog</span></p><p><b>name</b>: Urologie</p></div>"
        },
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/ad2-o1"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "11429006",
                "display" : "Consultation"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0306",
                "display" : "Medisch specialisten, urologie"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.045",
                "display" : "Uroloog"
              }
            ]
          }
        ],
        "name" : "Urologie"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/ad2-hs6"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad2-pr1",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "ad2-pr1",
        "meta" : {
          "source" : "https://cp2-test.example.org/fhirr4/PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitionerrole"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_ad2-pr1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole ad2-pr1</b></p><a name=\"ad2-pr1\"> </a><a name=\"hcad2-pr1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4/PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba\">https://cp2-test.example.org/fhirr4/PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-practitionerrole.html\">NL Generic Functions PractitionerRole Profile</a></p></div><p><b>identifier</b>: <code>http://cp2.example.org/HRM/assignments</code>/123456, <code>http://fhir.nl/fhir/NamingSystem/uzi</code>/UZI-1</p><p><b>practitioner</b>: <a href=\"Bundle-query-directory.html#Practitioner_ad2-p1\">Practitioner Caroline van Dijk(official)</a></p><p><b>organization</b>: <a href=\"Bundle-query-directory.html#Organization_ad2-o1\">Organization example Hospital</a></p><p><b>code</b>: <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.010}\">Cardioloog</span></p><p><b>specialty</b>: <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.010}\">Cardioloog</span></p><p><b>telecom</b>: <a href=\"mailto:c.vandijk@cp2.example.org\">c.vandijk@cp2.example.org</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://cp2.example.org/HRM/assignments",
            "value" : "123456"
          },
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/uzi",
            "value" : "UZI-1"
          }
        ],
        "practitioner" : {
          "reference" : "Practitioner/ad2-p1"
        },
        "organization" : {
          "reference" : "Organization/ad2-o1"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.010",
                "display" : "Cardioloog"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.010",
                "display" : "Cardioloog"
              }
            ]
          }
        ],
        "telecom" : [
          {
            "system" : "email",
            "value" : "c.vandijk@cp2.example.org"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "PractitionerRole/ad2-pr1"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad2-p1",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "ad2-p1",
        "meta" : {
          "source" : "https://cp2-test.example.org/fhirr4/Practitioner/040b160a-6072-4244-adc0-2b786c4ef052",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_ad2-p1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner ad2-p1</b></p><a name=\"ad2-p1\"> </a><a name=\"hcad2-p1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4/Practitioner/040b160a-6072-4244-adc0-2b786c4ef052\">https://cp2-test.example.org/fhirr4/Practitioner/040b160a-6072-4244-adc0-2b786c4ef052</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-practitioner.html\">NL Generic Functions Practitioner Profile</a></p></div><p><b>identifier</b>: <code>http://cp2.example.org/HRM/employees</code>/1234</p><p><b>name</b>: Caroline van Dijk(Official)</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://cp2.example.org/HRM/employees",
            "value" : "1234"
          }
        ],
        "name" : [
          {
            "use" : "official",
            "text" : "Caroline van Dijk",
            "family" : "van Dijk",
            "given" : ["Caroline"]
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Practitioner/ad2-p1"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad3-o1",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "ad3-o1",
        "meta" : {
          "source" : "https://cp3-test.example.org/fhirr4/Organization/3e799075-63a2-4a4c-913d-a91b8198463d",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_ad3-o1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization ad3-o1</b></p><a name=\"ad3-o1\"> </a><a name=\"hcad3-o1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp3-test.example.org/fhirr4/Organization/3e799075-63a2-4a4c-913d-a91b8198463d\">https://cp3-test.example.org/fhirr4/Organization/3e799075-63a2-4a4c-913d-a91b8198463d</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-organization.html\">NL Generic Functions Organization Profile</a></p></div><p><b>identifier</b>: Ura/33333333</p><p><b>type</b>: <span title=\"Codes:{http://nictiz.nl/fhir/NamingSystem/organization-type X3}\">Verplegings- of verzorgingsinstelling</span></p><p><b>name</b>: example Care Institution</p><p><b>telecom</b>: <a href=\"tel:+31301234567\">+31301234567</a>, <a href=\"mailto:info@organization3.nl\">info@organization3.nl</a></p><p><b>address</b>: Smidsstraat 10 Zelhem 7021 AC </p><p><b>endpoint</b>: <a href=\"Bundle-query-directory.html#Endpoint_ad3-e1\">Endpoint FHIR R4 Endpoint</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/ura",
            "value" : "33333333"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
                "code" : "X3",
                "display" : "Verplegings- of verzorgingsinstelling"
              }
            ]
          }
        ],
        "name" : "example Care Institution",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31301234567",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@organization3.nl",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["Smidsstraat 10"],
            "_line" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "Smidsstraat"
                  },
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "10"
                  }
                ]
              }
            ],
            "city" : "Zelhem",
            "postalCode" : "7021 AC"
          }
        ],
        "endpoint" : [
          {
            "reference" : "Endpoint/ad3-e1"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Organization/ad3-o1"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad3-o2",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "ad3-o2",
        "meta" : {
          "source" : "https://cp3-test.example.org/fhirr4/Organization/631cf10e-42d6-4165-9907-11e2333d4a85",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_ad3-o2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization ad3-o2</b></p><a name=\"ad3-o2\"> </a><a name=\"hcad3-o2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp3-test.example.org/fhirr4/Organization/631cf10e-42d6-4165-9907-11e2333d4a85\">https://cp3-test.example.org/fhirr4/Organization/631cf10e-42d6-4165-9907-11e2333d4a85</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-organization.html\">NL Generic Functions Organization Profile</a></p></div><p><b>type</b>: <span title=\"Codes:{http://nictiz.nl/fhir/NamingSystem/organization-type X3}\">Verplegings- of verzorgingsinstelling</span></p><p><b>name</b>: Nursing department at Organization 3</p><p><b>partOf</b>: <a href=\"Bundle-query-directory.html#Organization_ad3-o1\">Organization example Care Institution</a></p></div>"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
                "code" : "X3",
                "display" : "Verplegings- of verzorgingsinstelling"
              }
            ]
          }
        ],
        "name" : "Nursing department at Organization 3",
        "partOf" : {
          "reference" : "Organization/ad3-o1"
        }
      },
      "request" : {
        "method" : "PUT",
        "url" : "Organization/ad3-o2"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad3-e1",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "ad3-e1",
        "meta" : {
          "source" : "https://cp3-test.example.org/fhirr4/Endpoint/8f224548-6d50-44b6-82c5-75826ee0900f",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_ad3-e1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint ad3-e1</b></p><a name=\"ad3-e1\"> </a><a name=\"hcad3-e1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp3-test.example.org/fhirr4/Endpoint/8f224548-6d50-44b6-82c5-75826ee0900f\">https://cp3-test.example.org/fhirr4/Endpoint/8f224548-6d50-44b6-82c5-75826ee0900f</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type hl7-fhir-rest</a>: HL7 FHIR</p><p><b>name</b>: FHIR R4 Endpoint</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/34270859</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@example.org\">info@example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client}\">Care Services Directory for Update Client</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp3-test.example.org/fhirr4\">https://cp3-test.example.org/fhirr4</a></p></div>"
        },
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR R4 Endpoint",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "34270859"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client",
                "display" : "Care Services Directory for Update Client"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp3-test.example.org/fhirr4"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/ad3-e1"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad3-e2",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "ad3-e2",
        "meta" : {
          "source" : "https://cp3-test.example.org/fhirr4/Endpoint/72a349cc-7336-4a91-873d-fc9349769e1a",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_ad3-e2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint ad3-e2</b></p><a name=\"ad3-e2\"> </a><a name=\"hcad3-e2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp3-test.example.org/fhirr4/Endpoint/72a349cc-7336-4a91-873d-fc9349769e1a\">https://cp3-test.example.org/fhirr4/Endpoint/72a349cc-7336-4a91-873d-fc9349769e1a</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type hl7-fhir-rest</a>: HL7 FHIR</p><p><b>name</b>: FHIR STU3 Endpoint</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/34270859</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@example.org\">info@example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities http://nictiz.nl/fhir/CapabilityStatement/eOverdracht-servercapabilities}\">Transfer of Care - eOverdracht Server</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp3-test.example.org/fhirstu3\">https://cp3-test.example.org/fhirstu3</a></p></div>"
        },
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR STU3 Endpoint",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "34270859"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://nictiz.nl/fhir/CapabilityStatement/eOverdracht-servercapabilities",
                "display" : "Transfer of Care - eOverdracht Server"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp3-test.example.org/fhirstu3"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/ad3-e2"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad3-hs1",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "ad3-hs1",
        "meta" : {
          "source" : "https://cp3-test.example.org/fhirr4/HealthcareService/4fcf98c7-b198-4d61-8b3e-5ea39e33c405",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_ad3-hs1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService ad3-hs1</b></p><a name=\"ad3-hs1\"> </a><a name=\"hcad3-hs1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp3-test.example.org/fhirr4/HealthcareService/4fcf98c7-b198-4d61-8b3e-5ea39e33c405\">https://cp3-test.example.org/fhirr4/HealthcareService/4fcf98c7-b198-4d61-8b3e-5ea39e33c405</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Bundle-query-directory.html#Organization_ad3-o1\">Organization example Care Institution</a></p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 146521000146103}\">Brief comprehensive geriatric assessment</span>, <span title=\"Codes:{http://snomed.info/sct 107101000146106}\">comprehensive geriatric assessment</span>, <span title=\"Codes:{http://snomed.info/sct 86944008}\">Visual field study</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0335}\">Medisch specialisten, geriatrie</span></p><p><b>name</b>: Geriatrie</p></div>"
        },
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/ad3-o1"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "146521000146103",
                "display" : "Brief comprehensive geriatric assessment"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "107101000146106",
                "display" : "comprehensive geriatric assessment"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "86944008",
                "display" : "Visual field study"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0335",
                "display" : "Medisch specialisten, geriatrie"
              }
            ]
          }
        ],
        "name" : "Geriatrie"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/ad3-hs1"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad3-hs2",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "ad3-hs2",
        "meta" : {
          "source" : "https://cp3-test.example.org/fhirr4/HealthcareService/b48826dc-2d58-479a-bfd3-80b7a9d69757",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_ad3-hs2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService ad3-hs2</b></p><a name=\"ad3-hs2\"> </a><a name=\"hcad3-hs2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp3-test.example.org/fhirr4/HealthcareService/b48826dc-2d58-479a-bfd3-80b7a9d69757\">https://cp3-test.example.org/fhirr4/HealthcareService/b48826dc-2d58-479a-bfd3-80b7a9d69757</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Bundle-query-directory.html#Organization_ad3-o2\">Organization Nursing department at Organization 3</a></p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 23044009}\">Patient transfer to skilled nursing facility for level 1 care</span>, <span title=\"Codes:{http://snomed.info/sct 58413007}\">Patient transfer to skilled nursing facility for level 2 care</span>, <span title=\"Codes:{http://snomed.info/sct 43495009}\">Patient transfer to skilled nursing facility for level 3 care</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0100}\">Verpleegkundige</span></p><p><b>name</b>: Verpleging</p></div>"
        },
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/ad3-o2"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "23044009",
                "display" : "Patient transfer to skilled nursing facility for level 1 care"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "58413007",
                "display" : "Patient transfer to skilled nursing facility for level 2 care"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "43495009",
                "display" : "Patient transfer to skilled nursing facility for level 3 care"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0100",
                "display" : "Verpleegkundige"
              }
            ]
          }
        ],
        "name" : "Verpleging"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/ad3-hs2"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad3-p1",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "ad3-p1",
        "meta" : {
          "source" : "https://cp3-test.example.org/fhirr4/Practitioner/08630c28-5e2a-4b0c-b8ce-f08f533246b9",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_ad3-p1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner ad3-p1</b></p><a name=\"ad3-p1\"> </a><a name=\"hcad3-p1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp3-test.example.org/fhirr4/Practitioner/08630c28-5e2a-4b0c-b8ce-f08f533246b9\">https://cp3-test.example.org/fhirr4/Practitioner/08630c28-5e2a-4b0c-b8ce-f08f533246b9</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-practitioner.html\">NL Generic Functions Practitioner Profile</a></p></div><p><b>active</b>: true</p><p><b>name</b>: John Doe </p><p><b>telecom</b>: <a href=\"tel:+31301234568\">+31301234568</a>, <a href=\"mailto:null\"/></p><p><b>address</b>: Smidsstraat 11 Zelhem 7021 AC </p></div>"
        },
        "active" : true,
        "name" : [
          {
            "family" : "Doe",
            "given" : ["John"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31301234568",
            "use" : "work"
          },
          {
            "system" : "email"
          }
        ],
        "address" : [
          {
            "line" : ["Smidsstraat 11"],
            "city" : "Zelhem",
            "postalCode" : "7021 AC"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Practitioner/ad3-p1"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad3-pr1",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "ad3-pr1",
        "meta" : {
          "source" : "https://cp3-test.example.org/fhirr4/PractitionerRole/d60525bd-5caf-4437-8f4b-4156300a27de",
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitionerrole"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_ad3-pr1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole ad3-pr1</b></p><a name=\"ad3-pr1\"> </a><a name=\"hcad3-pr1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp3-test.example.org/fhirr4/PractitionerRole/d60525bd-5caf-4437-8f4b-4156300a27de\">https://cp3-test.example.org/fhirr4/PractitionerRole/d60525bd-5caf-4437-8f4b-4156300a27de</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-practitionerrole.html\">NL Generic Functions PractitionerRole Profile</a></p></div><p><b>active</b>: true</p><p><b>practitioner</b>: <a href=\"Bundle-query-directory.html#Practitioner_ad3-p1\">Practitioner John Doe </a></p><p><b>organization</b>: <a href=\"Bundle-query-directory.html#Organization_ad3-o1\">Organization example Care Institution</a></p><p><b>code</b>: <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.022}\">Klinisch geriater</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0335}\">Medisch specialisten, geriatrie</span>, <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.022}\">Klinisch geriater</span></p><p><b>telecom</b>: <a href=\"tel:+31301234568\">+31301234568</a>, <a href=\"mailto:john.doe@cp3.example.org\">john.doe@cp3.example.org</a>, <a href=\"https://matrix.to/#doctorno:cp3.example.org\">https://matrix.to/#doctorno:cp3.example.org</a></p></div>"
        },
        "active" : true,
        "practitioner" : {
          "reference" : "Practitioner/ad3-p1"
        },
        "organization" : {
          "reference" : "Organization/ad3-o1"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.022",
                "display" : "Klinisch geriater"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0335",
                "display" : "Medisch specialisten, geriatrie"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.022",
                "display" : "Klinisch geriater"
              }
            ]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31301234568",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "john.doe@cp3.example.org",
            "use" : "work"
          },
          {
            "system" : "url",
            "value" : "https://matrix.to/#doctorno:cp3.example.org",
            "use" : "work"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "PractitionerRole/ad3-pr1"
      }
    }
  ]
}

```
