# Supported ActivityDefinitions and PlanDefinitions by HealthcareServices - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Supported ActivityDefinitions and PlanDefinitions by HealthcareServices**

## Extension: Supported ActivityDefinitions and PlanDefinitions by HealthcareServices 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/supported-activity-definitions | *Version*:0.3.0 |
| Draft as of 2026-02-03 | *Computable Name*:SupportedActivityDefinitions |

ActivityDefinitions or PlanDefinitions to specify the codeable concepts in HealthcareService.type.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.nl.gf|current/StructureDefinition/supported-activity-definitions)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-supported-activity-definitions.csv), [Excel](StructureDefinition-supported-activity-definitions.xlsx), [Schematron](StructureDefinition-supported-activity-definitions.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "supported-activity-definitions",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/supported-activity-definitions",
  "version" : "0.3.0",
  "name" : "SupportedActivityDefinitions",
  "title" : "Supported ActivityDefinitions and PlanDefinitions by HealthcareServices",
  "status" : "draft",
  "date" : "2026-02-03T11:12:33+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "ActivityDefinitions or PlanDefinitions to specify the codeable concepts in HealthcareService.type.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "HealthcareService"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Supported ActivityDefinitions and PlanDefinitions by HealthcareServices",
        "definition" : "ActivityDefinitions or PlanDefinitions to specify the codeable concepts in HealthcareService.type."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/supported-activity-definitions"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "canonical",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/ActivityDefinition",
              "http://hl7.org/fhir/StructureDefinition/PlanDefinition"
            ]
          }
        ]
      }
    ]
  }
}

```
