# Organisation 2 - ServiceRequest Nursing - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organisation 2 - ServiceRequest Nursing**

## Example ServiceRequest: Organisation 2 - ServiceRequest Nursing

version: 1

Profile: [nl core Procedure request](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure-request)

**identifier**: `https://cp2-test.example.org/ServiceRequest`/53a41e63-e826-45fa-9076-9be4b18399c8

**status**: Active

**intent**: Order

**code**: VV Beschermd wonen met intensieve verzorging en verpleging

**subject**: [Patient Jaantje Merkens](Patient-27e58ece-409e-44f9-8cc1-b33495a0ef9d.md)

**requester**: [Caroline van Dijk at Organization 2](PractitionerRole-f051d3bd-26ff-4030-a5b6-fc4ef2be83ba.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "53a41e63-e826-45fa-9076-9be4b18399c8",
  "meta" : {
    "versionId" : "1",
    "profile" : [
      "http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure-request"
    ]
  },
  "identifier" : [
    {
      "system" : "https://cp2-test.example.org/ServiceRequest",
      "value" : "53a41e63-e826-45fa-9076-9be4b18399c8",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "22222222"
        }
      }
    }
  ],
  "status" : "active",
  "intent" : "order",
  "code" : {
    "coding" : [
      {
        "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-wlz-zorgprofielen-cs",
        "code" : "6VV",
        "display" : "VV Beschermd wonen met intensieve verzorging en verpleging"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/27e58ece-409e-44f9-8cc1-b33495a0ef9d",
    "display" : "Patient Jaantje Merkens"
  },
  "requester" : {
    "reference" : "PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba",
    "display" : "Caroline van Dijk at Organization 2"
  }
}

```
