# Organization 3 - HealthcareService Verpleging - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 3 - HealthcareService Verpleging**

## Example HealthcareService: Organization 3 - HealthcareService Verpleging

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**identifier**: `https://cp3-test.example.org/services`/b48826dc-2d58-479a-bfd3-80b7a9d69757

**active**: true

**providedBy**: [Organization Nursing department at Organization 3](Organization-631cf10e-42d6-4165-9907-11e2333d4a85.md)

**type**: VV Beschermd wonen met intensieve dementiezorg, VV Beschermd wonen met intensieve verzorging en verpleging, VV Beschermd wonen met zeer intensieve zorg, vanwege specifieke aandoeningen, met de nadruk op begeleiding, VV Beschermd wonen met zeer intensieve zorg, vanwege specifieke aandoeningen, met de nadruk op verzorging/verpleging

**specialty**: Verpleegkundige

**location**: 

* [Location Verpleeghuis Weltevree](Location-9a2b8f1c-4e7d-42a1-b3c9-2d5e8f7a6c1b.md)
* [Location Main Building](Location-7c5e3d2a-1f9e-4b8c-9d6a-8e2f5c3b1a4d.md)

**name**: Verpleging



## Resource Content

```json
{
  "resourceType" : "HealthcareService",
  "id" : "b48826dc-2d58-479a-bfd3-80b7a9d69757",
  "meta" : {
    "profile" : [
      "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
    ]
  },
  "identifier" : [
    {
      "system" : "https://cp3-test.example.org/services",
      "value" : "b48826dc-2d58-479a-bfd3-80b7a9d69757",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "33333333"
        }
      }
    }
  ],
  "active" : true,
  "providedBy" : {
    "reference" : "Organization/631cf10e-42d6-4165-9907-11e2333d4a85"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-wlz-zorgprofielen-cs",
          "code" : "5VV",
          "display" : "VV Beschermd wonen met intensieve dementiezorg"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-wlz-zorgprofielen-cs",
          "code" : "6VV",
          "display" : "VV Beschermd wonen met intensieve verzorging en verpleging"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-wlz-zorgprofielen-cs",
          "code" : "7VV",
          "display" : "VV Beschermd wonen met zeer intensieve zorg, vanwege specifieke aandoeningen, met de nadruk op begeleiding"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-wlz-zorgprofielen-cs",
          "code" : "8VV",
          "display" : "VV Beschermd wonen met zeer intensieve zorg, vanwege specifieke aandoeningen, met de nadruk op verzorging/verpleging"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
          "code" : "0100",
          "display" : "Verpleegkundige"
        }
      ]
    }
  ],
  "location" : [
    {
      "reference" : "Location/9a2b8f1c-4e7d-42a1-b3c9-2d5e8f7a6c1b"
    },
    {
      "reference" : "Location/7c5e3d2a-1f9e-4b8c-9d6a-8e2f5c3b1a4d"
    }
  ],
  "name" : "Verpleging"
}

```
