# Authorization - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* **Authorization**

## Authorization

| |
| :--- |
| *Page standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) |

### Introduction

### Solution overview

Input –> policy evaluation –> Output

Key principles:

* The scope of GF Authorization only specifies the input-variables, output-variables of the authorization decision. ****How to obtain and verify the inputs, is out-of-scope****; other pages in this IG specify the use of authoritative sources, certificates and/or verifiable credentials.
* Authorization policies are expressed in the [Rego policy language](https://www.openpolicyagent.org/docs/policy-language) to avoid semantic ambiguity and support automated testing. The Rego-policy inputs and outputs are inspired by API specified in the [OpenID AuthZen specification](https://openid.net/specs/authorization-api-1_0.html)
* Implementers are not required to use the Rego-policy-language (nor the OpenID AuthZen API) in production systems, but the outcome of their authorization decisions SHALL match the outcome using the original, specified authorization policy.

### Components (actors)

Reuse actor specification in [XACML](https://www.oasis-open.org/committees/xacml/repository/cs-xacml-specification-1.1.pdf)

### Data models

Reuse API specification in [OpenID AuthZen specification](https://openid.net/specs/authorization-api-1_0.html)

### Security and privacy considerations

??

### Example use cases

#### Lokalization-service authorization

example inputs

include Rego-policy

show/explain output

#### EPS request authorization

example inputs

include Rego-policy

show/explain output

### Roadmap

?? <!– comments meeting 24-nov 14:00:

Aandachtspunten

* Scope/capabilitystatement input
* Policy maker must use REGO
* how does TANP fit in?
* geen architectuurkeuzes voorschrijven: b.v. term PDP niet noemen

Houd rekening met verschillende lezers:

* policy makers
* PEP -implementers
* vendors (die integratiewerk moeten verrichten om extra inputs op te halen en te verifieren)
* beschrijf: waar verwachten we welke input? Welke inputs zijn er mogelijk? Waar kan je die inputs in de request verwachten? –>

