# Patient Jaantje Merkens - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient Jaantje Merkens**

## Example Patient: Patient Jaantje Merkens

Profile: [nl core Patient](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Patient)

Jaantje Merkens Female, DoB: 1950-02-26 ( http://organization2.example.org/EHR/patients#vdfesz)

-------

| | |
| :--- | :--- |
| Other Id: | `http://fhir.nl/fhir/NamingSystem/bsn`/111222333 |
| Contact Detail | * [+31612345678](tel:+31612345678)
* [j.merkens@bigtech.com](mailto:j.merkens@bigtech.com)
* Kerkstraat 18 Ulft 7071 WZ 
 |
| Links: | * Managing Organization: [Organization 2](Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.md)
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "27e58ece-409e-44f9-8cc1-b33495a0ef9d",
  "meta" : {
    "profile" : ["http://nictiz.nl/fhir/StructureDefinition/nl-core-Patient"]
  },
  "identifier" : [
    {
      "system" : "http://organization2.example.org/EHR/patients",
      "value" : "vdfesz"
    },
    {
      "system" : "http://fhir.nl/fhir/NamingSystem/bsn",
      "value" : "111222333"
    }
  ],
  "name" : [
    {
      "family" : "Merkens",
      "given" : ["Jaantje"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+31612345678"
    },
    {
      "system" : "email",
      "value" : "j.merkens@bigtech.com"
    }
  ],
  "gender" : "female",
  "birthDate" : "1950-02-26",
  "address" : [
    {
      "line" : ["Kerkstraat 18"],
      "city" : "Ulft",
      "postalCode" : "7071 WZ"
    }
  ],
  "managingOrganization" : {
    "reference" : "Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067",
    "display" : "Organization 2"
  }
}

```
