# NL Generic Functions Localization DocumentReference Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions Localization DocumentReference Profile**

## Resource Profile: NL Generic Functions Localization DocumentReference Profile 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-localization-documentreference | *Version*:0.3.0 |
| Draft as of 2026-01-30 | *Computable Name*:NlGfLocalizationDocumentReference |

 
A DocumentReference profile for registering the availability of patient data at healthcare organizations for localization services. This profile is used to indicate that certain patient data is available at a specific organization and can be accessed for localization purposes. 

**Usages:**

* Examples for this Profile: [DocumentReference/52b792ba-11ae-42f3-bcc1-231f333f2317](DocumentReference-52b792ba-11ae-42f3-bcc1-231f333f2317.md)
* CapabilityStatements using this Profile: [Localization Service](CapabilityStatement-nl-gf-localization-repository.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.nl.gf|current/StructureDefinition/nl-gf-localization-documentreference)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-localization-documentreference.csv), [Excel](StructureDefinition-nl-gf-localization-documentreference.xlsx), [Schematron](StructureDefinition-nl-gf-localization-documentreference.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-localization-documentreference",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-localization-documentreference",
  "version" : "0.3.0",
  "name" : "NlGfLocalizationDocumentReference",
  "title" : "NL Generic Functions Localization DocumentReference Profile",
  "status" : "draft",
  "date" : "2026-01-30T16:04:54+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "A DocumentReference profile for registering the availability of patient data at healthcare organizations for localization services. This profile is used to indicate that certain patient data is available at a specific organization and can be accessed for localization purposes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "fhircomposition",
      "uri" : "http://hl7.org/fhir/composition",
      "name" : "FHIR Composition"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "xds",
      "uri" : "http://ihe.net/xds",
      "name" : "XDS metadata equivalent"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DocumentReference",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DocumentReference",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DocumentReference",
        "path" : "DocumentReference"
      },
      {
        "id" : "DocumentReference.type",
        "path" : "DocumentReference.type",
        "min" : 1
      },
      {
        "id" : "DocumentReference.subject",
        "path" : "DocumentReference.subject",
        "min" : 1
      },
      {
        "id" : "DocumentReference.subject.reference",
        "path" : "DocumentReference.subject.reference",
        "max" : "0"
      },
      {
        "id" : "DocumentReference.subject.identifier.system",
        "path" : "DocumentReference.subject.identifier.system",
        "patternUri" : "http://fhir.nl/fhir/NamingSystem/pseudo-bsn"
      },
      {
        "id" : "DocumentReference.custodian",
        "path" : "DocumentReference.custodian",
        "min" : 1
      },
      {
        "id" : "DocumentReference.custodian.reference",
        "path" : "DocumentReference.custodian.reference",
        "max" : "0"
      },
      {
        "id" : "DocumentReference.custodian.identifier.system",
        "path" : "DocumentReference.custodian.identifier.system",
        "patternUri" : "http://fhir.nl/fhir/NamingSystem/ura"
      },
      {
        "id" : "DocumentReference.content.attachment.contentType",
        "path" : "DocumentReference.content.attachment.contentType",
        "min" : 1
      },
      {
        "id" : "DocumentReference.content.attachment.url",
        "path" : "DocumentReference.content.attachment.url",
        "min" : 1
      }
    ]
  }
}

```
