# Request key material [GFI-001] - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Authentication**](authentication.md)
* **Request key material [GFI-001]**

## Request key material [GFI-001]

### Scope

The Resolve key material transaction returns a document containing the public key material for a given entity.

### Actor Roles

| | |
| :--- | :--- |
| Verifier | Requests key material for a given entity based on a Decentralized Identifier (DID) |
| Issuer/Holder | Responds to the request with the public key material associated with the DID |

### Referenced standards

* [DID Core](https://www.w3.org/TR/did-core/)
* [DID Resolution](https://www.w3.org/TR/did-resolution/)
* [DID Web Method](https://w3c-ccg.github.io/did-method-web/)

### Messages

1. Resolve DID Document Request
1. DID Document Response

#### Resolve DID Document Request

##### Trigger events

A verifier needs to verify the authenticity of a signature on a verifiable credential or presentation.

##### Message semantics

A verifier initiates a resolve DID document request using a HTTP GET request to the DID web url. No further parameters are required. The DID web url is constructed following the rules as defined in the [DID Web Method](https://w3c-ccg.github.io/did-method-web/).

##### Example

Example `did:web`

```
did:web:example.com:user:alice

```

Which resolves to the DID document at:

```
GET https://example.com/user/alice/did.json

```

#### DID Document Response

##### Trigger events

The requested party responds to the resolve DID document request.

##### Message semantics

The requested party responds with a `HTTP 200 OK` response containing the DID document in the body of the response. The DID document is a JSON-LD document conforming to the [DID Core](https://www.w3.org/TR/did-core/) specification.

##### Example

```
{
  "@context": "https://www.w3.org/ns/did/v1",
  "id": "did:web:example.com:user:alice",
  "verificationMethod": [
    {
      "id": "did:web:example.com:user:alice#key-1",
      "type": "JsonWebKey2020",
      "controller": "did:web:example.com:user:alice",
      "publicKeyJwk": {
        "kty": "EC",
        "crv": "P-256",
        "x": "...",
        "y": "..."
      }
    }
  ],
  "authentication": ["did:web:example.com:user:alice#key-1"]
}

```

##### Expected actions

**Case 1**: The DID document is found on the server.

`HTTP 200` (OK) is returned as the HTTP status code.

A DID document is returned in the body of the response.

**Case 2**: The DID document is not found on the server.

`HTTP 404` (Not Found) is returned as the HTTP status code.

No body is returned in the response.

