# Organization 3 - Endpoint FHIR STU3 - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 3 - Endpoint FHIR STU3**

## Example Endpoint: Organization 3 - Endpoint FHIR STU3

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**identifier**: `https://cp3-test.example.org/api`/72a349cc-7336-4a91-873d-fc9349769e1a

**status**: Active

**connectionType**: [Endpoint Connection Type: hl7-fhir-rest](http://terminology.hl7.org/7.0.1/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest) (HL7 FHIR)

**name**: FHIR STU3 Endpoint

**managingOrganization**: Identifier: `http://fhir.nl/fhir/NamingSystem/kvk`/34270859

**contact**: [+3131599991](tel:+3131599991), [info@example.org](mailto:info@example.org)

**payloadType**: Transfer of Care - eOverdracht Server

**payloadMimeType**: application/fhir+json

**address**: [https://cp3-test.example.org/fhirstu3](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp3-test.example.org/fhirstu3)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "ad3-e2",
  "meta" : {
    "profile" : [
      "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
    ]
  },
  "identifier" : [
    {
      "system" : "https://cp3-test.example.org/api",
      "value" : "72a349cc-7336-4a91-873d-fc9349769e1a",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "33333333"
        }
      }
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
    "code" : "hl7-fhir-rest"
  },
  "name" : "FHIR STU3 Endpoint",
  "managingOrganization" : {
    "identifier" : {
      "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
      "value" : "34270859"
    }
  },
  "contact" : [
    {
      "system" : "phone",
      "value" : "+3131599991",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@example.org",
      "use" : "work"
    }
  ],
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
          "code" : "http://nictiz.nl/fhir/CapabilityStatement/eOverdracht-servercapabilities",
          "display" : "Transfer of Care - eOverdracht Server"
        }
      ]
    }
  ],
  "payloadMimeType" : ["application/fhir+json"],
  "address" : "https://cp3-test.example.org/fhirstu3"
}

```
