# NL Generic Functions Practitioner Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions Practitioner Profile**

## Resource Profile: NL Generic Functions Practitioner Profile 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitioner | *Version*:0.3.0 |
| Draft as of 2026-01-30 | *Computable Name*:NlGfPractitioner |

 
The details of a healthcare practitioner, such as a doctor or nurse, who is directly or indirectly involved in the provisioning of healthcare. 

**Usages:**

* Examples for this Profile: [Practitioner/040b160a-6072-4244-adc0-2b786c4ef052](Practitioner-040b160a-6072-4244-adc0-2b786c4ef052.md), [Practitioner/08630c28-5e2a-4b0c-b8ce-f08f533246b9](Practitioner-08630c28-5e2a-4b0c-b8ce-f08f533246b9.md), [Practitioner/9a63e407-34af-4ae4-ad3c-f7107fbbc0cd](Practitioner-9a63e407-34af-4ae4-ad3c-f7107fbbc0cd.md), [Practitioner/ad1-p1](Practitioner-ad1-p1.md)... Show 2 more, [Practitioner/ad2-p1](Practitioner-ad2-p1.md) and [Practitioner/ad3-p1](Practitioner-ad3-p1.md)
* CapabilityStatements using this Profile: [Administration Directory for Administration Client](CapabilityStatement-nl-gf-admin-directory-admin-client.md), [Administration Directory for Update Client](CapabilityStatement-nl-gf-admin-directory-update-client.md), [Query Directory for Query Client for only Read operations](CapabilityStatement-nl-gf-query-directory-query-client-reads.md) and [Query Directory for Query Client](CapabilityStatement-nl-gf-query-directory-query-client.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.nl.gf|current/StructureDefinition/nl-gf-practitioner)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-practitioner.csv), [Excel](StructureDefinition-nl-gf-practitioner.xlsx), [Schematron](StructureDefinition-nl-gf-practitioner.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-practitioner",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitioner",
  "version" : "0.3.0",
  "name" : "NlGfPractitioner",
  "title" : "NL Generic Functions Practitioner Profile",
  "status" : "draft",
  "date" : "2026-01-30T16:04:54+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "The details of a healthcare practitioner, such as a doctor or nurse, who is directly or indirectly involved in the provisioning of healthcare.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "zib-healthprofessional-v3.5-2020EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.5(2020EN)",
      "name" : "zib HealthProfessional-v3.5(2020EN)"
    },
    {
      "identity" : "zib-contactinformation-v1.2-2020EN",
      "uri" : "https://zibs.nl/wiki/ContactInformation-v1.2(2020EN)",
      "name" : "zib ContactInformation-v1.2(2020EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/nl-core-HealthProfessional-Practitioner",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner"
      },
      {
        "id" : "Practitioner.implicitRules",
        "path" : "Practitioner.implicitRules",
        "max" : "0"
      },
      {
        "id" : "Practitioner.modifierExtension",
        "path" : "Practitioner.modifierExtension",
        "max" : "0"
      },
      {
        "id" : "Practitioner.identifier",
        "path" : "Practitioner.identifier",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier:AssignedId",
        "path" : "Practitioner.identifier",
        "sliceName" : "AssignedId",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Practitioner.identifier:AssignedId.system",
        "path" : "Practitioner.identifier.system",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier:AssignedId.value",
        "path" : "Practitioner.identifier.value",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier:AssignedId.assigner",
        "path" : "Practitioner.identifier.assigner",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier:AssignedId.assigner.identifier",
        "path" : "Practitioner.identifier.assigner.identifier",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier:AssignedId.assigner.identifier.type",
        "path" : "Practitioner.identifier.assigner.identifier.type",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier:AssignedId.assigner.identifier.type.coding",
        "path" : "Practitioner.identifier.assigner.identifier.type.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Practitioner.identifier:AssignedId.assigner.identifier.type.coding.system",
        "path" : "Practitioner.identifier.assigner.identifier.type.coding.system",
        "patternUri" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type"
      },
      {
        "id" : "Practitioner.identifier:AssignedId.assigner.identifier.type.coding.code",
        "path" : "Practitioner.identifier.assigner.identifier.type.coding.code",
        "patternCode" : "author"
      },
      {
        "id" : "Practitioner.identifier:AssignedId.assigner.identifier.system",
        "path" : "Practitioner.identifier.assigner.identifier.system",
        "patternUri" : "http://fhir.nl/fhir/NamingSystem/ura"
      },
      {
        "id" : "Practitioner.identifier:AssignedId.assigner.identifier.value",
        "path" : "Practitioner.identifier.assigner.identifier.value",
        "min" : 1
      },
      {
        "id" : "Practitioner.name",
        "path" : "Practitioner.name",
        "min" : 1
      }
    ]
  }
}

```
