# NL Generic Functions Endpoint Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions Endpoint Profile**

## Resource Profile: NL Generic Functions Endpoint Profile 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint | *Version*:0.3.0 |
| Draft as of 2026-01-08 | *Computable Name*:NlGfEndpoint |

 
The technical details of an endpoint that can be used for electronic services, such as for web services providing access to FHIR resources. 

**Usages:**

* Examples for this Profile: [FHIR STU3 Endpoint](Endpoint-2427ca0c-8a29-4a6a-aabd-50cf02f587a7.md), [FHIR Endpoint 2](Endpoint-430f7379-8ec2-4e55-b096-919995da61e2.md), [FHIR Endpoint 3](Endpoint-553416dd-da12-40f7-a9bd-eb3e193177bd.md), [FHIR Endpoint 1](Endpoint-59654248-477c-4694-b156-e0042f0765a6.md)...Show 14 more,[FHIR STU3 Endpoint](Endpoint-72a349cc-7336-4a91-873d-fc9349769e1a.md),[FHIR R4 Endpoint](Endpoint-8f224548-6d50-44b6-82c5-75826ee0900f.md),[FHIR Endpoint 2](Endpoint-960a4f8c-74d8-482c-97ab-e2a025869fee.md),[FHIR Endpoint 1](Endpoint-ad1-e1.md),[FHIR Endpoint 2](Endpoint-ad2-e1.md),[DICOM-WADO-RS Endpoint](Endpoint-ad2-e2.md),[FHIR STU3 Endpoint](Endpoint-ad2-e3.md),[FHIR R4 Endpoint](Endpoint-ad3-e1.md),[FHIR STU3 Endpoint](Endpoint-ad3-e2.md),[DICOM-WADO-RS Endpoint](Endpoint-d4c1d657-67a9-471c-9732-9c042e9a6d43.md),[FHIR Endpoint 1](Endpoint-ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4.md),[FHIR Endpoint 1](Endpoint-lrza-e1.md),[FHIR Endpoint 2](Endpoint-lrza-e2.md)and[FHIR Endpoint 3](Endpoint-lrza-e3.md)
* CapabilityStatements using this Profile: [Administration Directory for Administration Client](CapabilityStatement-nl-gf-admin-directory-admin-client.md), [Administration Directory for Update Client](CapabilityStatement-nl-gf-admin-directory-update-client.md), [Query Directory for Query Client for only Read operations](CapabilityStatement-nl-gf-query-directory-query-client-reads.md) and [Query Directory for Query Client](CapabilityStatement-nl-gf-query-directory-query-client.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.nl.gf|current/StructureDefinition/nl-gf-endpoint)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-endpoint.csv), [Excel](StructureDefinition-nl-gf-endpoint.xlsx), [Schematron](StructureDefinition-nl-gf-endpoint.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-endpoint",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint",
  "version" : "0.3.0",
  "name" : "NlGfEndpoint",
  "title" : "NL Generic Functions Endpoint Profile",
  "status" : "draft",
  "date" : "2026-01-08T14:40:48+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "The technical details of an endpoint that can be used for electronic services, such as for web services providing access to FHIR resources.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Endpoint",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Endpoint",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Endpoint",
        "path" : "Endpoint"
      },
      {
        "id" : "Endpoint.implicitRules",
        "path" : "Endpoint.implicitRules",
        "max" : "0"
      },
      {
        "id" : "Endpoint.modifierExtension",
        "path" : "Endpoint.modifierExtension",
        "max" : "0"
      },
      {
        "id" : "Endpoint.managingOrganization",
        "path" : "Endpoint.managingOrganization",
        "min" : 1
      },
      {
        "id" : "Endpoint.payloadType",
        "path" : "Endpoint.payloadType",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://nuts-foundation.github.io/nl-generic-functions-ig/ValueSet/nl-gf-data-exchange-capabilities-vs"
        }
      }
    ]
  }
}

```
