# NL GF Organization Types ValueSet - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL GF Organization Types ValueSet**

## ValueSet: NL GF Organization Types ValueSet (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://minvws.github.io/generiekefuncties-docs/ValueSet/nl-gf-org-types-vs | *Version*:0.1.0 |
| Active as of 2026-02-17 | *Computable Name*:NlGfOrgTypesVS |

 
The Organization Types supported by the NL Generic Functions. 

 **References** 

* [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "nl-gf-org-types-vs",
  "url" : "http://minvws.github.io/generiekefuncties-docs/ValueSet/nl-gf-org-types-vs",
  "version" : "0.1.0",
  "name" : "NlGfOrgTypesVS",
  "title" : "NL GF Organization Types ValueSet",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-02-17T11:30:22+00:00",
  "publisher" : "Ministerie van Volksgezondheid, Welzijn en Sport",
  "contact" : [
    {
      "name" : "Ministerie van Volksgezondheid, Welzijn en Sport",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.minvws.nl"
        }
      ]
    }
  ],
  "description" : "The Organization Types supported by the NL Generic Functions.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "http://decor.nictiz.nl/fhir/ValueSet/2.16.840.1.113883.2.4.3.11.60.40.2.17.2.4--20200901000000"
        ]
      },
      {
        "system" : "http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-sbi-2025-cs"
      }
    ]
  }
}

```
