# HealthcareService for Task in STU3 - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HealthcareService for Task in STU3**

## Extension: HealthcareService for Task in STU3 

| | |
| :--- | :--- |
| *Official URL*:http://minvws.github.io/generiekefuncties-docs/StructureDefinition/task-stu3-healthcareservice | *Version*:0.1.0 |
| Draft as of 2026-02-17 | *Computable Name*:TaskSTU3HealthcareService |

The healthcare service where the task is performed.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [NL Generic Functions Task Profile for FHIR STU3](StructureDefinition-nl-gf-task-stu3.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.gf|current/StructureDefinition/task-stu3-healthcareservice)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-task-stu3-healthcareservice.csv), [Excel](StructureDefinition-task-stu3-healthcareservice.xlsx), [Schematron](StructureDefinition-task-stu3-healthcareservice.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "task-stu3-healthcareservice",
  "url" : "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/task-stu3-healthcareservice",
  "version" : "0.1.0",
  "name" : "TaskSTU3HealthcareService",
  "title" : "HealthcareService for Task in STU3",
  "status" : "draft",
  "date" : "2026-02-17T11:30:22+00:00",
  "publisher" : "Ministerie van Volksgezondheid, Welzijn en Sport",
  "contact" : [
    {
      "name" : "Ministerie van Volksgezondheid, Welzijn en Sport",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.minvws.nl"
        }
      ]
    }
  ],
  "description" : "The healthcare service where the task is performed.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "HealthcareService for Task in STU3",
        "definition" : "The healthcare service where the task is performed."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/task-stu3-healthcareservice"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-healthcareservice"
            ]
          }
        ]
      }
    ]
  }
}

```
