# Organization 3 - PractitionerRole Klinisch Geriater John Doe - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 3 - PractitionerRole Klinisch Geriater John Doe**

## Example PractitionerRole: Organization 3 - PractitionerRole Klinisch Geriater John Doe

Profile: [NL Generic Functions PractitionerRole Profile](StructureDefinition-nl-gf-practitionerrole.md)

**identifier**: `https://cp3-test.example.org/employees`/d60525bd-5caf-4437-8f4b-4156300a27de

**active**: true

**practitioner**: [Practitioner John Doe ](Practitioner-ad3-p1.md)

**organization**: [Organization example Care Institution](Organization-ad3-o1.md)

**code**: Klinisch geriater

**specialty**: Medisch specialisten, geriatrie, Klinisch geriater

**telecom**: [+31301234568](tel:+31301234568), [john.doe@cp3.example.org](mailto:john.doe@cp3.example.org), [https://matrix.to/#doctorno:cp3.example.org](https://matrix.to/#doctorno:cp3.example.org)



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "ad3-pr1",
  "meta" : {
    "profile" : [
      "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-practitionerrole"
    ]
  },
  "identifier" : [
    {
      "system" : "https://cp3-test.example.org/employees",
      "value" : "d60525bd-5caf-4437-8f4b-4156300a27de",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "33333333"
        }
      }
    }
  ],
  "active" : true,
  "practitioner" : {
    "reference" : "Practitioner/ad3-p1"
  },
  "organization" : {
    "reference" : "Organization/ad3-o1"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
          "code" : "01.022",
          "display" : "Klinisch geriater"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
          "code" : "0335",
          "display" : "Medisch specialisten, geriatrie"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
          "code" : "01.022",
          "display" : "Klinisch geriater"
        }
      ]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+31301234568",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "john.doe@cp3.example.org",
      "use" : "work"
    },
    {
      "system" : "url",
      "value" : "https://matrix.to/#doctorno:cp3.example.org",
      "use" : "work"
    }
  ]
}

```
