# Organization 2 - Endpoint FHIR STU3 - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 2 - Endpoint FHIR STU3**

## Example Endpoint: Organization 2 - Endpoint FHIR STU3

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**identifier**: `https://cp2-test.example.org/api`/2427ca0c-8a29-4a6a-aabd-50cf02f587a7

**status**: Active

**connectionType**: [Endpoint Connection Type: hl7-fhir-rest](http://terminology.hl7.org/7.0.1/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest) (HL7 FHIR)

**name**: FHIR STU3 Endpoint

**managingOrganization**: Identifier: `http://fhir.nl/fhir/NamingSystem/kvk`/08013836

**contact**: [+3131599991](tel:+3131599991), [info@nedap.example.org](mailto:info@nedap.example.org)

**payloadType**: Transfer of Care - eOverdracht Server

**payloadMimeType**: application/fhir+json

**address**: [https://cp2-test.example.org/fhirstu3](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirstu3)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "2427ca0c-8a29-4a6a-aabd-50cf02f587a7",
  "meta" : {
    "profile" : [
      "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-endpoint"
    ]
  },
  "identifier" : [
    {
      "system" : "https://cp2-test.example.org/api",
      "value" : "2427ca0c-8a29-4a6a-aabd-50cf02f587a7",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "22222222"
        }
      }
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
    "code" : "hl7-fhir-rest"
  },
  "name" : "FHIR STU3 Endpoint",
  "managingOrganization" : {
    "identifier" : {
      "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
      "value" : "08013836"
    }
  },
  "contact" : [
    {
      "system" : "phone",
      "value" : "+3131599991",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@nedap.example.org",
      "use" : "work"
    }
  ],
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-data-exchange-capabilities",
          "code" : "http://nictiz.nl/fhir/CapabilityStatement/eOverdracht-servercapabilities",
          "display" : "Transfer of Care - eOverdracht Server"
        }
      ]
    }
  ],
  "payloadMimeType" : ["application/fhir+json"],
  "address" : "https://cp2-test.example.org/fhirstu3"
}

```
