# Bundle of care services in HIS of Organization 1 - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle of care services in HIS of Organization 1**

## Example Bundle: Bundle of care services in HIS of Organization 1



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "admin-directory-org1",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:4cb35b96-f021-4e15-bf71-d67a6d4bebec",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "4cb35b96-f021-4e15-bf71-d67a6d4bebec",
        "meta" : {
          "profile" : [
            "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_4cb35b96-f021-4e15-bf71-d67a6d4bebec\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization 4cb35b96-f021-4e15-bf71-d67a6d4bebec</b></p><a name=\"4cb35b96-f021-4e15-bf71-d67a6d4bebec\"> </a><a name=\"hc4cb35b96-f021-4e15-bf71-d67a6d4bebec\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-organization.html\">NL Generic Functions Organization Profile</a></p></div><p><b>identifier</b>: Ura/11111111, <code>https://cp1-test.example.org/departments</code>/4cb35b96-f021-4e15-bf71-d67a6d4bebec</p><p><b>type</b>: <span title=\"Codes:{http://nictiz.nl/fhir/NamingSystem/organization-type Z3}\">Huisartspraktijk (zelfstandig of groepspraktijk)</span></p><p><b>name</b>: example General Practice</p><p><b>telecom</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@cp1.example.org\">info@cp1.example.org</a></p><p><b>address</b>: Vogelenzangweg 31 null null Ulft 7071 PT </p><p><b>endpoint</b>: <a href=\"Endpoint-59654248-477c-4694-b156-e0042f0765a6.html\">Endpoint FHIR Endpoint 1</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/ura",
            "value" : "11111111"
          },
          {
            "system" : "https://cp1-test.example.org/departments",
            "value" : "4cb35b96-f021-4e15-bf71-d67a6d4bebec",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "11111111"
              }
            }
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
                "code" : "Z3",
                "display" : "Huisartspraktijk (zelfstandig of groepspraktijk)"
              }
            ]
          }
        ],
        "name" : "example General Practice",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@cp1.example.org",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["Vogelenzangweg 31", null, null],
            "_line" : [
              null,
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "Vogelenzangweg"
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "31"
                  }
                ]
              }
            ],
            "city" : "Ulft",
            "postalCode" : "7071 PT"
          }
        ],
        "endpoint" : [
          {
            "reference" : "Endpoint/59654248-477c-4694-b156-e0042f0765a6"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Organization/4cb35b96-f021-4e15-bf71-d67a6d4bebec"
      }
    },
    {
      "fullUrl" : "urn:uuid:59654248-477c-4694-b156-e0042f0765a6",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "59654248-477c-4694-b156-e0042f0765a6",
        "meta" : {
          "profile" : [
            "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_59654248-477c-4694-b156-e0042f0765a6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint 59654248-477c-4694-b156-e0042f0765a6</b></p><a name=\"59654248-477c-4694-b156-e0042f0765a6\"> </a><a name=\"hc59654248-477c-4694-b156-e0042f0765a6\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>identifier</b>: <code>https://cp1-test.example.org/api</code>/59654248-477c-4694-b156-e0042f0765a6</p><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type: hl7-fhir-rest</a> (HL7 FHIR)</p><p><b>name</b>: FHIR Endpoint 1</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/51494752</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@cp1.example.org\">info@cp1.example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-data-exchange-capabilities http://minvws.github.io/generiekefuncties-docs/CapabilityStatement/nl-gf-admin-directory-update-client}\">Care Services Directory for Update Client</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp1-test.example.org/fhirr4\">https://cp1-test.example.org/fhirr4</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp1-test.example.org/api",
            "value" : "59654248-477c-4694-b156-e0042f0765a6",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "11111111"
              }
            }
          }
        ],
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR Endpoint 1",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "51494752"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@cp1.example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://minvws.github.io/generiekefuncties-docs/CapabilityStatement/nl-gf-admin-directory-update-client",
                "display" : "Care Services Directory for Update Client"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp1-test.example.org/fhirr4"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/59654248-477c-4694-b156-e0042f0765a6"
      }
    },
    {
      "fullUrl" : "urn:uuid:5fa4c91a-a12f-48ae-a4c7-92971dc7ab53",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "5fa4c91a-a12f-48ae-a4c7-92971dc7ab53",
        "meta" : {
          "profile" : [
            "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-practitionerrole"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_5fa4c91a-a12f-48ae-a4c7-92971dc7ab53\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole 5fa4c91a-a12f-48ae-a4c7-92971dc7ab53</b></p><a name=\"5fa4c91a-a12f-48ae-a4c7-92971dc7ab53\"> </a><a name=\"hc5fa4c91a-a12f-48ae-a4c7-92971dc7ab53\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-practitionerrole.html\">NL Generic Functions PractitionerRole Profile</a></p></div><p><b>identifier</b>: <code>https://cp1-test.example.org/employees</code>/5fa4c91a-a12f-48ae-a4c7-92971dc7ab53</p><p><b>practitioner</b>: <a href=\"Practitioner-9a63e407-34af-4ae4-ad3c-f7107fbbc0cd.html\">Practitioner Hary Arts(official)</a></p><p><b>organization</b>: <a href=\"Organization-4cb35b96-f021-4e15-bf71-d67a6d4bebec.html\">Organization example General Practice</a></p><p><b>code</b>: <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.015}\">Huisarts</span></p><p><b>telecom</b>: <a href=\"mailto:h.arts@cp1.example.org\">h.arts@cp1.example.org</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp1-test.example.org/employees",
            "value" : "5fa4c91a-a12f-48ae-a4c7-92971dc7ab53",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "11111111"
              }
            }
          }
        ],
        "practitioner" : {
          "reference" : "Practitioner/9a63e407-34af-4ae4-ad3c-f7107fbbc0cd"
        },
        "organization" : {
          "reference" : "Organization/4cb35b96-f021-4e15-bf71-d67a6d4bebec"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.015",
                "display" : "Huisarts"
              }
            ]
          }
        ],
        "telecom" : [
          {
            "system" : "email",
            "value" : "h.arts@cp1.example.org"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "PractitionerRole/5fa4c91a-a12f-48ae-a4c7-92971dc7ab53"
      }
    },
    {
      "fullUrl" : "urn:uuid:9a63e407-34af-4ae4-ad3c-f7107fbbc0cd",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "9a63e407-34af-4ae4-ad3c-f7107fbbc0cd",
        "meta" : {
          "profile" : [
            "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_9a63e407-34af-4ae4-ad3c-f7107fbbc0cd\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 9a63e407-34af-4ae4-ad3c-f7107fbbc0cd</b></p><a name=\"9a63e407-34af-4ae4-ad3c-f7107fbbc0cd\"> </a><a name=\"hc9a63e407-34af-4ae4-ad3c-f7107fbbc0cd\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-practitioner.html\">NL Generic Functions Practitioner Profile</a></p></div><p><b>identifier</b>: <code>http://fhir.nl/fhir/NamingSystem/uzi</code>/UZI-2, <code>https://cp1-test.example.org/employees</code>/5678</p><p><b>name</b>: Hary Arts(Official)</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/uzi",
            "value" : "UZI-2"
          },
          {
            "system" : "https://cp1-test.example.org/employees",
            "value" : "5678",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "11111111"
              }
            }
          }
        ],
        "name" : [
          {
            "use" : "official",
            "text" : "Hary Arts",
            "family" : "Arts",
            "given" : ["Harry"]
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Practitioner/9a63e407-34af-4ae4-ad3c-f7107fbbc0cd"
      }
    },
    {
      "fullUrl" : "urn:uuid:ehr-system-example-001",
      "resource" : {
        "resourceType" : "Device",
        "id" : "ehr-system-example-001",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Device_ehr-system-example-001\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Device ehr-system-example-001</b></p><a name=\"ehr-system-example-001\"> </a><a name=\"hcehr-system-example-001\"> </a><p><b>identifier</b>: <code>http://example.org/device-identifiers</code>/EHR-SYS-2024-001, <a href=\"http://terminology.hl7.org/5.3.0/NamingSystem-uri.html\" title=\"As defined by RFC 3986 (http://www.ietf.org/rfc/rfc3986.txt)(with many schemes defined in many RFCs). For OIDs and UUIDs, use the URN form (urn:oid:(note: lowercase) and urn:uuid:). See http://www.ietf.org/rfc/rfc3001.txt and http://www.ietf.org/rfc/rfc4122.txt \r\n\r\nThis oid is used as an identifier II.root to indicate the the extension is an absolute URI (technically, an IRI). Typically, this is used for OIDs and GUIDs. Note that when this OID is used with OIDs and GUIDs, the II.extension should start with urn:oid or urn:uuid: \r\n\r\nNote that this OID is created to aid with interconversion between CDA and FHIR - FHIR uses urn:ietf:rfc:3986 as equivalent to this OID. URIs as identifiers appear more commonly in FHIR.\r\n\r\nThis OID may also be used in CD.codeSystem.\">Uniform Resource Identifier (URI)</a>/urn:uuid:a1b2c3d4-e5f6-7890-abcd-ef1234567890</p><p><b>status</b>: Active</p><p><b>manufacturer</b>: HealthTech Solutions BV</p><blockquote><p><b>deviceName</b></p><p><b>name</b>: MedicalRecords Pro</p><p><b>type</b>: User Friendly name</p></blockquote><blockquote><p><b>deviceName</b></p><p><b>name</b>: MRP-Enterprise-v5.2</p><p><b>type</b>: Model name</p></blockquote><p><b>modelNumber</b>: MRP-ENT-5.2.1</p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 706689003}\">Electronic Health Record System</span></p><blockquote><p><b>version</b></p><p><b>type</b>: <span title=\"Codes:{http://hl7.org/fhir/device-versiontype software}\">software</span></p><p><b>value</b>: 5.2.1</p></blockquote><blockquote><p><b>version</b></p><p><b>type</b>: <span title=\"Codes:{http://hl7.org/fhir/device-versiontype firmware}\">firmware</span></p><p><b>value</b>: 2.8.0</p></blockquote><p><b>owner</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/9999999</p><p><b>contact</b>: <a href=\"mailto:support@healthtech.example.com\">support@healthtech.example.com</a>, <a href=\"tel:+31201234567\">+31201234567</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://example.org/device-identifiers",
            "value" : "EHR-SYS-2024-001"
          },
          {
            "system" : "urn:ietf:rfc:3986",
            "value" : "urn:uuid:a1b2c3d4-e5f6-7890-abcd-ef1234567890"
          }
        ],
        "status" : "active",
        "manufacturer" : "HealthTech Solutions BV",
        "deviceName" : [
          {
            "name" : "MedicalRecords Pro",
            "type" : "user-friendly-name"
          },
          {
            "name" : "MRP-Enterprise-v5.2",
            "type" : "model-name"
          }
        ],
        "modelNumber" : "MRP-ENT-5.2.1",
        "type" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "706689003",
              "display" : "Electronic health record system application software"
            }
          ],
          "text" : "Electronic Health Record System"
        },
        "version" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/device-versiontype",
                  "code" : "software"
                }
              ]
            },
            "value" : "5.2.1"
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/device-versiontype",
                  "code" : "firmware"
                }
              ]
            },
            "value" : "2.8.0"
          }
        ],
        "owner" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "9999999"
          }
        },
        "contact" : [
          {
            "system" : "email",
            "value" : "support@healthtech.example.com"
          },
          {
            "system" : "phone",
            "value" : "+31201234567",
            "use" : "work"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Device/ehr-system-example-001"
      }
    }
  ]
}

```
