# Organization 2 - Task for ServiceRequest Nursing - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 2 - Task for ServiceRequest Nursing**

## Example Task: Organization 2 - Task for ServiceRequest Nursing

**identifier**: `https://cp2-test.example.org/tasks`/a0fc5221-bcd9-46f1-922f-c2913dae5d63

**status**: Requested

**intent**: order

**code**: Fulfill the focal request

**focus**: [ServiceRequest Nursing](ServiceRequest-53a41e63-e826-45fa-9076-9be4b18399c8.md)

**for**: [Jaantje Merkens Female, DoB: 1950-02-26 ( http://organization2.example.org/EHR/patients#vdfesz)](Patient-27e58ece-409e-44f9-8cc1-b33495a0ef9d.md)

**requester**: [Caroline van Dijk at Organization 2](PractitionerRole-f051d3bd-26ff-4030-a5b6-fc4ef2be83ba.md)

**owner**: [Organization 3 - HealthcareService Verpleging](HealthcareService-b48826dc-2d58-479a-bfd3-80b7a9d69757.md)

**location**: [Organization 3 - Location Nursing Department](Location-9a2b8f1c-4e7d-42a1-b3c9-2d5e8f7a6c1b.md)



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "a0fc5221-bcd9-46f1-922f-c2913dae5d63",
  "identifier" : [
    {
      "system" : "https://cp2-test.example.org/tasks",
      "value" : "a0fc5221-bcd9-46f1-922f-c2913dae5d63",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "22222222"
        }
      }
    }
  ],
  "status" : "requested",
  "intent" : "order",
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/CodeSystem/task-code",
        "code" : "fulfill"
      }
    ]
  },
  "focus" : {
    "reference" : "ServiceRequest/53a41e63-e826-45fa-9076-9be4b18399c8",
    "display" : "ServiceRequest Nursing"
  },
  "for" : {
    "reference" : "Patient/27e58ece-409e-44f9-8cc1-b33495a0ef9d"
  },
  "requester" : {
    "reference" : "PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba",
    "display" : "Caroline van Dijk at Organization 2"
  },
  "owner" : {
    "reference" : "HealthcareService/b48826dc-2d58-479a-bfd3-80b7a9d69757",
    "display" : "Organization 3 - HealthcareService Verpleging"
  },
  "location" : {
    "reference" : "Location/9a2b8f1c-4e7d-42a1-b3c9-2d5e8f7a6c1b",
    "display" : "Organization 3 - Location Nursing Department"
  }
}

```
