# NL Generic Functions OrganizationAffiliation Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions OrganizationAffiliation Profile**

## Resource Profile: NL Generic Functions OrganizationAffiliation Profile 

| | |
| :--- | :--- |
| *Official URL*:http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-organizationaffiliation | *Version*:0.1.0 |
| Draft as of 2026-02-17 | *Computable Name*:NlGfOrganizationAffiliation |

 
The details of an affiliation/relationship between two organizations, such as a healthcare provider and a software vendor. 

**Usages:**

* CapabilityStatements using this Profile: [Administration Directory for Administration Client](CapabilityStatement-nl-gf-admin-directory-admin-client.md), [Administration Directory for Update Client](CapabilityStatement-nl-gf-admin-directory-update-client.md), [Query Directory for Query Client for only Read operations](CapabilityStatement-nl-gf-query-directory-query-client-reads.md) and [Query Directory for Query Client](CapabilityStatement-nl-gf-query-directory-query-client.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.gf|current/StructureDefinition/nl-gf-organizationaffiliation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-organizationaffiliation.csv), [Excel](StructureDefinition-nl-gf-organizationaffiliation.xlsx), [Schematron](StructureDefinition-nl-gf-organizationaffiliation.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-organizationaffiliation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile",
      "valueCanonical" : "https://profiles.ihe.net/ITI/mCSD/StructureDefinition/IHE.mCSD.OrganizationAffiliation"
    }
  ],
  "url" : "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-organizationaffiliation",
  "version" : "0.1.0",
  "name" : "NlGfOrganizationAffiliation",
  "title" : "NL Generic Functions OrganizationAffiliation Profile",
  "status" : "draft",
  "date" : "2026-02-17T11:30:22+00:00",
  "publisher" : "Ministerie van Volksgezondheid, Welzijn en Sport",
  "contact" : [
    {
      "name" : "Ministerie van Volksgezondheid, Welzijn en Sport",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.minvws.nl"
        }
      ]
    }
  ],
  "description" : "The details of an affiliation/relationship between two organizations, such as a healthcare provider and a software vendor.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "OrganizationAffiliation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/OrganizationAffiliation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "OrganizationAffiliation",
        "path" : "OrganizationAffiliation"
      },
      {
        "id" : "OrganizationAffiliation.implicitRules",
        "path" : "OrganizationAffiliation.implicitRules",
        "max" : "0"
      },
      {
        "id" : "OrganizationAffiliation.modifierExtension",
        "path" : "OrganizationAffiliation.modifierExtension",
        "max" : "0"
      },
      {
        "id" : "OrganizationAffiliation.identifier",
        "path" : "OrganizationAffiliation.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "OrganizationAffiliation.identifier:AssignedId",
        "path" : "OrganizationAffiliation.identifier",
        "sliceName" : "AssignedId",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-authorassignedidentifier"
            ]
          }
        ]
      },
      {
        "id" : "OrganizationAffiliation.active",
        "path" : "OrganizationAffiliation.active",
        "min" : 1
      },
      {
        "id" : "OrganizationAffiliation.organization",
        "path" : "OrganizationAffiliation.organization",
        "min" : 1
      },
      {
        "id" : "OrganizationAffiliation.participatingOrganization",
        "path" : "OrganizationAffiliation.participatingOrganization",
        "min" : 1
      },
      {
        "id" : "OrganizationAffiliation.code",
        "path" : "OrganizationAffiliation.code",
        "min" : 1
      }
    ]
  }
}

```
