# Organization 2 - Organization - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 2 - Organization**

## Example Organization: Organization 2 - Organization

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/22222222, `https://cp2-test.example.org/departments`/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067

**type**: Ziekenhuis, Hospital

**name**: example Hospital

**telecom**: [+31301234567](tel:+31301234567), [info@cp2.example.org](mailto:info@cp2.example.org)

**address**: Catharinastraat 21 Doetinchem 7001 BZ 

**endpoint**: 

* [Endpoint FHIR Endpoint 2](Endpoint-ad2-e1.md)
* [Endpoint DICOM-WADO-RS Endpoint](Endpoint-ad2-e2.md)
* [Endpoint FHIR STU3 Endpoint](Endpoint-ad2-e3.md)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "ad2-o1",
  "meta" : {
    "profile" : [
      "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-organization"
    ]
  },
  "identifier" : [
    {
      "system" : "http://fhir.nl/fhir/NamingSystem/ura",
      "value" : "22222222"
    },
    {
      "system" : "https://cp2-test.example.org/departments",
      "value" : "cff921f3-c1c1-4a4c-8f0f-cafd0aa25067",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "22222222"
        }
      }
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
          "code" : "V4",
          "display" : "Ziekenhuis"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "22232009",
          "display" : "Hospital"
        }
      ]
    }
  ],
  "name" : "example Hospital",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+31301234567",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@cp2.example.org",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["Catharinastraat 21"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Catharinastraat"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "21"
            }
          ]
        }
      ],
      "city" : "Doetinchem",
      "postalCode" : "7001 BZ"
    }
  ],
  "endpoint" : [
    {
      "reference" : "Endpoint/ad2-e1"
    },
    {
      "reference" : "Endpoint/ad2-e2"
    },
    {
      "reference" : "Endpoint/ad2-e3"
    }
  ]
}

```
