# Organization 1 - Organization - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 1 - Organization**

## Example Organization: Organization 1 - Organization

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/11111111, `https://cp1-test.example.org/departments`/4cb35b96-f021-4e15-bf71-d67a6d4bebec

**type**: Huisartspraktijk (zelfstandig of groepspraktijk)

**name**: example General Practice

**telecom**: [+3131599991](tel:+3131599991), [info@cp1.example.org](mailto:info@cp1.example.org)

**address**: Vogelenzangweg 31 null null Ulft 7071 PT 

**endpoint**: [Endpoint FHIR Endpoint 1](Endpoint-59654248-477c-4694-b156-e0042f0765a6.md)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "4cb35b96-f021-4e15-bf71-d67a6d4bebec",
  "meta" : {
    "profile" : [
      "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-organization"
    ]
  },
  "identifier" : [
    {
      "system" : "http://fhir.nl/fhir/NamingSystem/ura",
      "value" : "11111111"
    },
    {
      "system" : "https://cp1-test.example.org/departments",
      "value" : "4cb35b96-f021-4e15-bf71-d67a6d4bebec",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "11111111"
        }
      }
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
          "code" : "Z3",
          "display" : "Huisartspraktijk (zelfstandig of groepspraktijk)"
        }
      ]
    }
  ],
  "name" : "example General Practice",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+3131599991",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@cp1.example.org",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["Vogelenzangweg 31", null, null],
      "_line" : [
        null,
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Vogelenzangweg"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "31"
            }
          ]
        }
      ],
      "city" : "Ulft",
      "postalCode" : "7071 PT"
    }
  ],
  "endpoint" : [
    {
      "reference" : "Endpoint/59654248-477c-4694-b156-e0042f0765a6"
    }
  ]
}

```
