# LRZa - Organization 2 - Organization - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **LRZa - Organization 2 - Organization**

## Example Organization: LRZa - Organization 2 - Organization

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/22222222

**type**: Ziekenhuis, Hospital

**name**: example Hospital

**telecom**: [+31301234567](tel:+31301234567), [info@cp2.example.org](mailto:info@cp2.example.org)

**address**: Catharinastraat 21 Doetinchem 7001 BZ 

**endpoint**: [Endpoint FHIR Endpoint 2](Endpoint-960a4f8c-74d8-482c-97ab-e2a025869fee.md)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "4815bbe6-9fea-4875-a16c-a168d63054d4",
  "meta" : {
    "profile" : [
      "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-organization"
    ]
  },
  "identifier" : [
    {
      "system" : "http://fhir.nl/fhir/NamingSystem/ura",
      "value" : "22222222",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
          "value" : "50000535"
        }
      }
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
          "code" : "V4",
          "display" : "Ziekenhuis"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "22232009",
          "display" : "Hospital"
        }
      ]
    }
  ],
  "name" : "example Hospital",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+31301234567",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@cp2.example.org",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["Catharinastraat 21"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Catharinastraat"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "21"
            }
          ]
        }
      ],
      "city" : "Doetinchem",
      "postalCode" : "7001 BZ"
    }
  ],
  "endpoint" : [
    {
      "reference" : "Endpoint/960a4f8c-74d8-482c-97ab-e2a025869fee"
    }
  ]
}

```
