# Organization 2 - HealthcareService Neurochirurgie - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 2 - HealthcareService Neurochirurgie**

## Example HealthcareService: Organization 2 - HealthcareService Neurochirurgie

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**identifier**: `https://cp2-test.example.org/services`/c79125e5-739f-4238-959c-cd5872518c1f

**active**: true

**providedBy**: [Organization example Hospital](Organization-ad2-o1.md)

**type**: Consultation

**specialty**: Medisch specialisten, neurochirurgie, Neurochirurg

**name**: Neurochirurgie



## Resource Content

```json
{
  "resourceType" : "HealthcareService",
  "id" : "ad2-hs2",
  "meta" : {
    "profile" : [
      "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-healthcareservice"
    ]
  },
  "identifier" : [
    {
      "system" : "https://cp2-test.example.org/services",
      "value" : "c79125e5-739f-4238-959c-cd5872518c1f",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "22222222"
        }
      }
    }
  ],
  "active" : true,
  "providedBy" : {
    "reference" : "Organization/ad2-o1"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "11429006",
          "display" : "Consultation"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
          "code" : "0308",
          "display" : "Medisch specialisten, neurochirurgie"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
          "code" : "01.025",
          "display" : "Neurochirurg"
        }
      ]
    }
  ],
  "name" : "Neurochirurgie"
}

```
