# Organization 1 - Endpoint - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 1 - Endpoint**

## Example Endpoint: Organization 1 - Endpoint

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**identifier**: `https://cp1-test.example.org/api`/59654248-477c-4694-b156-e0042f0765a6

**status**: Active

**connectionType**: [Endpoint Connection Type: hl7-fhir-rest](http://terminology.hl7.org/7.0.1/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest) (HL7 FHIR)

**name**: FHIR Endpoint 1

**managingOrganization**: Identifier: `http://fhir.nl/fhir/NamingSystem/kvk`/51494752

**contact**: [+3131599991](tel:+3131599991), [info@cp1.example.org](mailto:info@cp1.example.org)

**payloadType**: Care Services Directory for Update Client

**payloadMimeType**: application/fhir+json

**address**: [https://cp1-test.example.org/fhirr4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp1-test.example.org/fhirr4)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "ad1-e1",
  "meta" : {
    "profile" : [
      "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-endpoint"
    ]
  },
  "identifier" : [
    {
      "system" : "https://cp1-test.example.org/api",
      "value" : "59654248-477c-4694-b156-e0042f0765a6",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "11111111"
        }
      }
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
    "code" : "hl7-fhir-rest"
  },
  "name" : "FHIR Endpoint 1",
  "managingOrganization" : {
    "identifier" : {
      "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
      "value" : "51494752"
    }
  },
  "contact" : [
    {
      "system" : "phone",
      "value" : "+3131599991",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@cp1.example.org",
      "use" : "work"
    }
  ],
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-data-exchange-capabilities",
          "code" : "http://minvws.github.io/generiekefuncties-docs/CapabilityStatement/nl-gf-admin-directory-update-client",
          "display" : "Care Services Directory for Update Client"
        }
      ]
    }
  ],
  "payloadMimeType" : ["application/fhir+json"],
  "address" : "https://cp1-test.example.org/fhirr4"
}

```
