# Bundle of care services in ECD of Organization 3 - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle of care services in ECD of Organization 3**

## Example Bundle: Bundle of care services in ECD of Organization 3



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "admin-directory-org3",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:3e799075-63a2-4a4c-913d-a91b8198463d",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "3e799075-63a2-4a4c-913d-a91b8198463d",
        "meta" : {
          "profile" : [
            "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_3e799075-63a2-4a4c-913d-a91b8198463d\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization 3e799075-63a2-4a4c-913d-a91b8198463d</b></p><a name=\"3e799075-63a2-4a4c-913d-a91b8198463d\"> </a><a name=\"hc3e799075-63a2-4a4c-913d-a91b8198463d\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-organization.html\">NL Generic Functions Organization Profile</a></p></div><p><b>identifier</b>: Ura/33333333, <code>https://cp3-test.example.org/departments</code>/3e799075-63a2-4a4c-913d-a91b8198463d</p><p><b>type</b>: <span title=\"Codes:{http://nictiz.nl/fhir/NamingSystem/organization-type X3}\">Verplegings- of verzorgingsinstelling</span></p><p><b>name</b>: example Care Institution</p><p><b>telecom</b>: <a href=\"tel:+31301234567\">+31301234567</a>, <a href=\"mailto:info@organization3.nl\">info@organization3.nl</a></p><p><b>address</b>: Smidsstraat 10 Zelhem 7021 AC </p><p><b>endpoint</b>: </p><ul><li><a href=\"Endpoint-8f224548-6d50-44b6-82c5-75826ee0900f.html\">Endpoint FHIR R4 Endpoint</a></li><li><a href=\"Endpoint-72a349cc-7336-4a91-873d-fc9349769e1a.html\">Endpoint FHIR STU3 Endpoint</a></li></ul></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/ura",
            "value" : "33333333"
          },
          {
            "system" : "https://cp3-test.example.org/departments",
            "value" : "3e799075-63a2-4a4c-913d-a91b8198463d",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "33333333"
              }
            }
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
                "code" : "X3",
                "display" : "Verplegings- of verzorgingsinstelling"
              }
            ]
          }
        ],
        "name" : "example Care Institution",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31301234567",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@organization3.nl",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["Smidsstraat 10"],
            "_line" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "Smidsstraat"
                  },
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "10"
                  }
                ]
              }
            ],
            "city" : "Zelhem",
            "postalCode" : "7021 AC"
          }
        ],
        "endpoint" : [
          {
            "reference" : "Endpoint/8f224548-6d50-44b6-82c5-75826ee0900f"
          },
          {
            "reference" : "Endpoint/72a349cc-7336-4a91-873d-fc9349769e1a"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Organization/3e799075-63a2-4a4c-913d-a91b8198463d"
      }
    },
    {
      "fullUrl" : "urn:uuid:631cf10e-42d6-4165-9907-11e2333d4a85",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "631cf10e-42d6-4165-9907-11e2333d4a85",
        "meta" : {
          "profile" : [
            "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_631cf10e-42d6-4165-9907-11e2333d4a85\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization 631cf10e-42d6-4165-9907-11e2333d4a85</b></p><a name=\"631cf10e-42d6-4165-9907-11e2333d4a85\"> </a><a name=\"hc631cf10e-42d6-4165-9907-11e2333d4a85\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-organization.html\">NL Generic Functions Organization Profile</a></p></div><p><b>identifier</b>: <code>https://cp3-test.example.org/departments</code>/631cf10e-42d6-4165-9907-11e2333d4a85</p><p><b>type</b>: <span title=\"Codes:{http://nictiz.nl/fhir/NamingSystem/organization-type X3}\">Verplegings- of verzorgingsinstelling</span></p><p><b>name</b>: Nursing department at Organization 3</p><p><b>partOf</b>: <a href=\"Organization-3e799075-63a2-4a4c-913d-a91b8198463d.html\">Organization example Care Institution</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp3-test.example.org/departments",
            "value" : "631cf10e-42d6-4165-9907-11e2333d4a85",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "33333333"
              }
            }
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
                "code" : "X3",
                "display" : "Verplegings- of verzorgingsinstelling"
              }
            ]
          }
        ],
        "name" : "Nursing department at Organization 3",
        "partOf" : {
          "reference" : "Organization/3e799075-63a2-4a4c-913d-a91b8198463d"
        }
      },
      "request" : {
        "method" : "PUT",
        "url" : "Organization/631cf10e-42d6-4165-9907-11e2333d4a85"
      }
    },
    {
      "fullUrl" : "urn:uuid:8f224548-6d50-44b6-82c5-75826ee0900f",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "8f224548-6d50-44b6-82c5-75826ee0900f",
        "meta" : {
          "profile" : [
            "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_8f224548-6d50-44b6-82c5-75826ee0900f\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint 8f224548-6d50-44b6-82c5-75826ee0900f</b></p><a name=\"8f224548-6d50-44b6-82c5-75826ee0900f\"> </a><a name=\"hc8f224548-6d50-44b6-82c5-75826ee0900f\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>identifier</b>: <code>https://cp3-test.example.org/api</code>/8f224548-6d50-44b6-82c5-75826ee0900f</p><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type: hl7-fhir-rest</a> (HL7 FHIR)</p><p><b>name</b>: FHIR R4 Endpoint</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/34270859</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@example.org\">info@example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-data-exchange-capabilities http://minvws.github.io/generiekefuncties-docs/CapabilityStatement/nl-gf-admin-directory-update-client}\">Care Services Directory for Update Client</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp3-test.example.org/fhirr4\">https://cp3-test.example.org/fhirr4</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp3-test.example.org/api",
            "value" : "8f224548-6d50-44b6-82c5-75826ee0900f",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "33333333"
              }
            }
          }
        ],
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR R4 Endpoint",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "34270859"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://minvws.github.io/generiekefuncties-docs/CapabilityStatement/nl-gf-admin-directory-update-client",
                "display" : "Care Services Directory for Update Client"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp3-test.example.org/fhirr4"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/8f224548-6d50-44b6-82c5-75826ee0900f"
      }
    },
    {
      "fullUrl" : "urn:uuid:72a349cc-7336-4a91-873d-fc9349769e1a",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "72a349cc-7336-4a91-873d-fc9349769e1a",
        "meta" : {
          "profile" : [
            "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_72a349cc-7336-4a91-873d-fc9349769e1a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint 72a349cc-7336-4a91-873d-fc9349769e1a</b></p><a name=\"72a349cc-7336-4a91-873d-fc9349769e1a\"> </a><a name=\"hc72a349cc-7336-4a91-873d-fc9349769e1a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>identifier</b>: <code>https://cp3-test.example.org/api</code>/72a349cc-7336-4a91-873d-fc9349769e1a</p><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type: hl7-fhir-rest</a> (HL7 FHIR)</p><p><b>name</b>: FHIR STU3 Endpoint</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/34270859</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@example.org\">info@example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-data-exchange-capabilities http://nictiz.nl/fhir/CapabilityStatement/eOverdracht-servercapabilities}\">Transfer of Care - eOverdracht Server</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp3-test.example.org/fhirstu3\">https://cp3-test.example.org/fhirstu3</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp3-test.example.org/api",
            "value" : "72a349cc-7336-4a91-873d-fc9349769e1a",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "33333333"
              }
            }
          }
        ],
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR STU3 Endpoint",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "34270859"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://nictiz.nl/fhir/CapabilityStatement/eOverdracht-servercapabilities",
                "display" : "Transfer of Care - eOverdracht Server"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp3-test.example.org/fhirstu3"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/72a349cc-7336-4a91-873d-fc9349769e1a"
      }
    },
    {
      "fullUrl" : "urn:uuid:4fcf98c7-b198-4d61-8b3e-5ea39e33c405",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "4fcf98c7-b198-4d61-8b3e-5ea39e33c405",
        "meta" : {
          "profile" : [
            "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_4fcf98c7-b198-4d61-8b3e-5ea39e33c405\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService 4fcf98c7-b198-4d61-8b3e-5ea39e33c405</b></p><a name=\"4fcf98c7-b198-4d61-8b3e-5ea39e33c405\"> </a><a name=\"hc4fcf98c7-b198-4d61-8b3e-5ea39e33c405\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>identifier</b>: <code>https://cp3-test.example.org/services</code>/4fcf98c7-b198-4d61-8b3e-5ea39e33c405</p><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Organization-3e799075-63a2-4a4c-913d-a91b8198463d.html\">Organization example Care Institution</a></p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 146521000146103}\">Brief comprehensive geriatric assessment</span>, <span title=\"Codes:{http://snomed.info/sct 107101000146106}\">comprehensive geriatric assessment</span>, <span title=\"Codes:{http://snomed.info/sct 86944008}\">Visual field study</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0335}\">Medisch specialisten, geriatrie</span></p><p><b>name</b>: Geriatrie</p></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp3-test.example.org/services",
            "value" : "4fcf98c7-b198-4d61-8b3e-5ea39e33c405",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "33333333"
              }
            }
          }
        ],
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/3e799075-63a2-4a4c-913d-a91b8198463d"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "146521000146103",
                "display" : "Brief comprehensive geriatric assessment"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "107101000146106",
                "display" : "comprehensive geriatric assessment"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "86944008",
                "display" : "Visual field study"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0335",
                "display" : "Medisch specialisten, geriatrie"
              }
            ]
          }
        ],
        "name" : "Geriatrie"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/4fcf98c7-b198-4d61-8b3e-5ea39e33c405"
      }
    },
    {
      "fullUrl" : "urn:uuid:b48826dc-2d58-479a-bfd3-80b7a9d69757",
      "resource" : {
        "resourceType" : "HealthcareService",
        "id" : "b48826dc-2d58-479a-bfd3-80b7a9d69757",
        "meta" : {
          "profile" : [
            "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-healthcareservice"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"HealthcareService_b48826dc-2d58-479a-bfd3-80b7a9d69757\"> </a><p class=\"res-header-id\"><b>Generated Narrative: HealthcareService b48826dc-2d58-479a-bfd3-80b7a9d69757</b></p><a name=\"b48826dc-2d58-479a-bfd3-80b7a9d69757\"> </a><a name=\"hcb48826dc-2d58-479a-bfd3-80b7a9d69757\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-healthcareservice.html\">NL Generic Functions HealthcareService Profile</a></p></div><p><b>identifier</b>: <code>https://cp3-test.example.org/services</code>/b48826dc-2d58-479a-bfd3-80b7a9d69757</p><p><b>active</b>: true</p><p><b>providedBy</b>: <a href=\"Organization-631cf10e-42d6-4165-9907-11e2333d4a85.html\">Organization Nursing department at Organization 3</a></p><p><b>type</b>: <span title=\"Codes:{http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-wlz-zorgprofielen-cs 5VV}\">VV Beschermd wonen met intensieve dementiezorg</span>, <span title=\"Codes:{http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-wlz-zorgprofielen-cs 6VV}\">VV Beschermd wonen met intensieve verzorging en verpleging</span>, <span title=\"Codes:{http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-wlz-zorgprofielen-cs 7VV}\">VV Beschermd wonen met zeer intensieve zorg, vanwege specifieke aandoeningen, met de nadruk op begeleiding</span>, <span title=\"Codes:{http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-wlz-zorgprofielen-cs 8VV}\">VV Beschermd wonen met zeer intensieve zorg, vanwege specifieke aandoeningen, met de nadruk op verzorging/verpleging</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0100}\">Verpleegkundige</span></p><p><b>location</b>: </p><ul><li><a href=\"Location-9a2b8f1c-4e7d-42a1-b3c9-2d5e8f7a6c1b.html\">Location Verpleeghuis Weltevree</a></li><li><a href=\"Location-7c5e3d2a-1f9e-4b8c-9d6a-8e2f5c3b1a4d.html\">Location Main Building</a></li></ul><p><b>name</b>: Verpleging</p></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp3-test.example.org/services",
            "value" : "b48826dc-2d58-479a-bfd3-80b7a9d69757",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "33333333"
              }
            }
          }
        ],
        "active" : true,
        "providedBy" : {
          "reference" : "Organization/631cf10e-42d6-4165-9907-11e2333d4a85"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-wlz-zorgprofielen-cs",
                "code" : "5VV",
                "display" : "VV Beschermd wonen met intensieve dementiezorg"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-wlz-zorgprofielen-cs",
                "code" : "6VV",
                "display" : "VV Beschermd wonen met intensieve verzorging en verpleging"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-wlz-zorgprofielen-cs",
                "code" : "7VV",
                "display" : "VV Beschermd wonen met zeer intensieve zorg, vanwege specifieke aandoeningen, met de nadruk op begeleiding"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-wlz-zorgprofielen-cs",
                "code" : "8VV",
                "display" : "VV Beschermd wonen met zeer intensieve zorg, vanwege specifieke aandoeningen, met de nadruk op verzorging/verpleging"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0100",
                "display" : "Verpleegkundige"
              }
            ]
          }
        ],
        "location" : [
          {
            "reference" : "Location/9a2b8f1c-4e7d-42a1-b3c9-2d5e8f7a6c1b"
          },
          {
            "reference" : "Location/7c5e3d2a-1f9e-4b8c-9d6a-8e2f5c3b1a4d"
          }
        ],
        "name" : "Verpleging"
      },
      "request" : {
        "method" : "PUT",
        "url" : "HealthcareService/b48826dc-2d58-479a-bfd3-80b7a9d69757"
      }
    },
    {
      "fullUrl" : "urn:uuid:08630c28-5e2a-4b0c-b8ce-f08f533246b9",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "08630c28-5e2a-4b0c-b8ce-f08f533246b9",
        "meta" : {
          "profile" : [
            "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_08630c28-5e2a-4b0c-b8ce-f08f533246b9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 08630c28-5e2a-4b0c-b8ce-f08f533246b9</b></p><a name=\"08630c28-5e2a-4b0c-b8ce-f08f533246b9\"> </a><a name=\"hc08630c28-5e2a-4b0c-b8ce-f08f533246b9\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-practitioner.html\">NL Generic Functions Practitioner Profile</a></p></div><p><b>identifier</b>: <code>https://cp3-test.example.org/physicians</code>/08630c28-5e2a-4b0c-b8ce-f08f533246b9, <code>http://fhir.nl/fhir/NamingSystem/uzi</code>/UZI-3</p><p><b>active</b>: true</p><p><b>name</b>: John Doe </p><p><b>telecom</b>: <a href=\"tel:+31301234568\">+31301234568</a>, <a href=\"mailto:null\"/></p><p><b>address</b>: Smidsstraat 11 Zelhem 7021 AC </p></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp3-test.example.org/physicians",
            "value" : "08630c28-5e2a-4b0c-b8ce-f08f533246b9",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "33333333"
              }
            }
          },
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/uzi",
            "value" : "UZI-3"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Doe",
            "given" : ["John"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31301234568",
            "use" : "work"
          },
          {
            "system" : "email"
          }
        ],
        "address" : [
          {
            "line" : ["Smidsstraat 11"],
            "city" : "Zelhem",
            "postalCode" : "7021 AC"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Practitioner/08630c28-5e2a-4b0c-b8ce-f08f533246b9"
      }
    },
    {
      "fullUrl" : "urn:uuid:d60525bd-5caf-4437-8f4b-4156300a27de",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "d60525bd-5caf-4437-8f4b-4156300a27de",
        "meta" : {
          "profile" : [
            "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-practitionerrole"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_d60525bd-5caf-4437-8f4b-4156300a27de\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole d60525bd-5caf-4437-8f4b-4156300a27de</b></p><a name=\"d60525bd-5caf-4437-8f4b-4156300a27de\"> </a><a name=\"hcd60525bd-5caf-4437-8f4b-4156300a27de\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-practitionerrole.html\">NL Generic Functions PractitionerRole Profile</a></p></div><p><b>identifier</b>: <code>https://cp3-test.example.org/employees</code>/d60525bd-5caf-4437-8f4b-4156300a27de</p><p><b>active</b>: true</p><p><b>practitioner</b>: <a href=\"Practitioner-08630c28-5e2a-4b0c-b8ce-f08f533246b9.html\">Practitioner John Doe </a></p><p><b>organization</b>: <a href=\"Organization-3e799075-63a2-4a4c-913d-a91b8198463d.html\">Organization example Care Institution</a></p><p><b>code</b>: <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.022}\">Klinisch geriater</span></p><p><b>specialty</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.4.6.7 0335}\">Medisch specialisten, geriatrie</span>, <span title=\"Codes:{http://fhir.nl/fhir/NamingSystem/uzi-rolcode 01.022}\">Klinisch geriater</span></p><p><b>telecom</b>: <a href=\"tel:+31301234568\">+31301234568</a>, <a href=\"mailto:john.doe@cp3.example.org\">john.doe@cp3.example.org</a>, <a href=\"https://matrix.to/#doctorno:cp3.example.org\">https://matrix.to/#doctorno:cp3.example.org</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp3-test.example.org/employees",
            "value" : "d60525bd-5caf-4437-8f4b-4156300a27de",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "33333333"
              }
            }
          }
        ],
        "active" : true,
        "practitioner" : {
          "reference" : "Practitioner/08630c28-5e2a-4b0c-b8ce-f08f533246b9"
        },
        "organization" : {
          "reference" : "Organization/3e799075-63a2-4a4c-913d-a91b8198463d"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.022",
                "display" : "Klinisch geriater"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
                "code" : "0335",
                "display" : "Medisch specialisten, geriatrie"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
                "code" : "01.022",
                "display" : "Klinisch geriater"
              }
            ]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31301234568",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "john.doe@cp3.example.org",
            "use" : "work"
          },
          {
            "system" : "url",
            "value" : "https://matrix.to/#doctorno:cp3.example.org",
            "use" : "work"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "PractitionerRole/d60525bd-5caf-4437-8f4b-4156300a27de"
      }
    }
  ]
}

```
