# NL GF Zorgcontext ValueSet - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL GF Zorgcontext ValueSet**

## ValueSet: NL GF Zorgcontext ValueSet (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://minvws.github.io/generiekefuncties-docs/ValueSet/nl-gf-zorgcontext-vs | *Version*:0.1.0 |
| Active as of 2026-02-17 | *Computable Name*:NlGfZorgcontextVS |

 
The care context concepts supported by the NL Generic Functions. 

 **References** 

* [NL Generic Functions Localization List Profile](StructureDefinition-nl-gf-localization-list.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "nl-gf-zorgcontext-vs",
  "url" : "http://minvws.github.io/generiekefuncties-docs/ValueSet/nl-gf-zorgcontext-vs",
  "version" : "0.1.0",
  "name" : "NlGfZorgcontextVS",
  "title" : "NL GF Zorgcontext ValueSet",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-02-17T17:25:51+00:00",
  "publisher" : "Ministerie van Volksgezondheid, Welzijn en Sport",
  "contact" : [
    {
      "name" : "Ministerie van Volksgezondheid, Welzijn en Sport",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.minvws.nl"
        }
      ]
    }
  ],
  "description" : "The care context concepts supported by the NL Generic Functions.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-zorgcontext-cs"
      }
    ]
  }
}

```
