# Pseudo-BSN Identifier - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Pseudo-BSN Identifier**

## Data Type Profile: Pseudo-BSN Identifier 

| | |
| :--- | :--- |
| *Official URL*:http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-pseudo-bsn-identifier | *Version*:0.1.0 |
| Draft as of 2026-02-17 | *Computable Name*:PseudoBsnIdentifier |

 
Identifier for pseudonymized Dutch citizen service numbers (BSN). 

**Usages:**

* Use this DataType Profile: [NL Generic Functions Localization List Profile](StructureDefinition-nl-gf-localization-list.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.gf|current/StructureDefinition/nl-gf-pseudo-bsn-identifier)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-pseudo-bsn-identifier.csv), [Excel](StructureDefinition-nl-gf-pseudo-bsn-identifier.xlsx), [Schematron](StructureDefinition-nl-gf-pseudo-bsn-identifier.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-pseudo-bsn-identifier",
  "url" : "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-pseudo-bsn-identifier",
  "version" : "0.1.0",
  "name" : "PseudoBsnIdentifier",
  "title" : "Pseudo-BSN Identifier",
  "status" : "draft",
  "date" : "2026-02-17T17:25:51+00:00",
  "publisher" : "Ministerie van Volksgezondheid, Welzijn en Sport",
  "contact" : [
    {
      "name" : "Ministerie van Volksgezondheid, Welzijn en Sport",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.minvws.nl"
        }
      ]
    }
  ],
  "description" : "Identifier for pseudonymized Dutch citizen service numbers (BSN).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Identifier",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Identifier",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Identifier.use",
        "path" : "Identifier.use",
        "patternCode" : "temp"
      },
      {
        "id" : "Identifier.system",
        "path" : "Identifier.system",
        "min" : 1,
        "fixedUri" : "http://fhir.nl/fhir/NamingSystem/pseudo-bsn"
      },
      {
        "id" : "Identifier.value",
        "path" : "Identifier.value",
        "min" : 1
      }
    ]
  }
}

```
