# NL Generic Functions Organization Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions Organization Profile**

## Resource Profile: NL Generic Functions Organization Profile 

| | |
| :--- | :--- |
| *Official URL*:http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-organization | *Version*:0.1.0 |
| Draft as of 2026-02-17 | *Computable Name*:NlGfOrganization |

 
The organizational hierarchy and details for healthcare organizations. 

**Usages:**

* Refer to this Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md), [NL Generic Functions Location Profile](StructureDefinition-nl-gf-location.md), [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md) and [NL Generic Functions PractitionerRole Profile](StructureDefinition-nl-gf-practitionerrole.md)
* Examples for this Profile: [example Care Institution](Organization-3e799075-63a2-4a4c-913d-a91b8198463d.md), [example General Practice](Organization-3f39dca9-a392-4eb3-8366-0c7ff53ab3a9.md), [example Hospital](Organization-4815bbe6-9fea-4875-a16c-a168d63054d4.md), [example General Practice](Organization-4cb35b96-f021-4e15-bf71-d67a6d4bebec.md)... Show 10 more, [Nursing department at Organization 3](Organization-631cf10e-42d6-4165-9907-11e2333d4a85.md), [example General Practice](Organization-ad1-o1.md), [example Hospital](Organization-ad2-o1.md), [example Care Institution](Organization-ad3-o1.md), [Nursing department at Organization 3](Organization-ad3-o2.md), [example Hospital](Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.md), [example Care Institution](Organization-fcf55b06-f22c-4058-9051-b77368bdd26b.md), [example General Practice](Organization-lrza-o1.md), [example Hospital](Organization-lrza-o2.md) and [example Care Institution](Organization-lrza-o3.md)
* CapabilityStatements using this Profile: [Administration Directory for Administration Client](CapabilityStatement-nl-gf-admin-directory-admin-client.md), [Administration Directory for Update Client](CapabilityStatement-nl-gf-admin-directory-update-client.md), [Query Directory for Query Client for only Read operations](CapabilityStatement-nl-gf-query-directory-query-client-reads.md) and [Query Directory for Query Client](CapabilityStatement-nl-gf-query-directory-query-client.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.gf|current/StructureDefinition/nl-gf-organization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-organization.csv), [Excel](StructureDefinition-nl-gf-organization.xlsx), [Schematron](StructureDefinition-nl-gf-organization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-organization",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile",
      "valueCanonical" : "https://profiles.ihe.net/ITI/mCSD/StructureDefinition/IHE.mCSD.Organization"
    }
  ],
  "url" : "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-organization",
  "version" : "0.1.0",
  "name" : "NlGfOrganization",
  "title" : "NL Generic Functions Organization Profile",
  "status" : "draft",
  "date" : "2026-02-17T17:25:51+00:00",
  "publisher" : "Ministerie van Volksgezondheid, Welzijn en Sport",
  "contact" : [
    {
      "name" : "Ministerie van Volksgezondheid, Welzijn en Sport",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.minvws.nl"
        }
      ]
    }
  ],
  "description" : "The organizational hierarchy and details for healthcare organizations.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "zib-healthcareprovider-v3.4-2020EN",
      "uri" : "https://zibs.nl/wiki/HealthcareProvider-v3.4(2020EN)",
      "name" : "zib HealthcareProvider-v3.4(2020EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/nl-core-HealthcareProvider-Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization",
        "constraint" : [
          {
            "key" : "ura-identifier-or-partof",
            "severity" : "error",
            "human" : "an Organization instance must either have an URA-identifier or must be 'partOf' some other instance that is an nl-gf-organization instance.",
            "expression" : "identifier.where(system='http://fhir.nl/fhir/NamingSystem/ura').exists() or partOf.exists()",
            "source" : "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-organization"
          }
        ]
      },
      {
        "id" : "Organization.implicitRules",
        "path" : "Organization.implicitRules",
        "max" : "0"
      },
      {
        "id" : "Organization.modifierExtension",
        "path" : "Organization.modifierExtension",
        "max" : "0"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:AssignedId",
        "path" : "Organization.identifier",
        "sliceName" : "AssignedId",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-authorassignedidentifier"
            ]
          }
        ]
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "min" : 1
      },
      {
        "id" : "Organization.type:SBI",
        "path" : "Organization.type",
        "sliceName" : "SBI",
        "short" : "SBI",
        "definition" : "CBS Standaard Bedrijfsindeling code representing the primary activity of the organization.",
        "alias" : ["Standaard Bedrijfsindeling"],
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://minvws.github.io/generiekefuncties-docs/ValueSet/nl-gf-org-types-vs"
        }
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "min" : 1
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-organization"
            ]
          }
        ]
      },
      {
        "id" : "Organization.endpoint",
        "path" : "Organization.endpoint",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-endpoint"
            ]
          }
        ]
      }
    ]
  }
}

```
