# NL Generic Functions Location Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions Location Profile**

## Resource Profile: NL Generic Functions Location Profile 

| | |
| :--- | :--- |
| *Official URL*:http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-location | *Version*:0.1.0 |
| Draft as of 2026-02-17 | *Computable Name*:NlGfLocation |

 
Physical location details for healthcare services, organizations, and practitioners. 

**Usages:**

* Refer to this Profile: [Location for Task in STU3](StructureDefinition-task-stu3-location.md)
* Examples for this Profile: [Main Building](Location-7c5e3d2a-1f9e-4b8c-9d6a-8e2f5c3b1a4d.md), [Verpleeghuis Weltevree](Location-9a2b8f1c-4e7d-42a1-b3c9-2d5e8f7a6c1b.md), [Main Building](Location-ad3-l1.md) and [Verpleeghuis Weltevree](Location-ad3-l2.md)
* CapabilityStatements using this Profile: [Administration Directory for Administration Client](CapabilityStatement-nl-gf-admin-directory-admin-client.md), [Administration Directory for Update Client](CapabilityStatement-nl-gf-admin-directory-update-client.md), [Query Directory for Query Client for only Read operations](CapabilityStatement-nl-gf-query-directory-query-client-reads.md) and [Query Directory for Query Client](CapabilityStatement-nl-gf-query-directory-query-client.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.gf|current/StructureDefinition/nl-gf-location)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-location.csv), [Excel](StructureDefinition-nl-gf-location.xlsx), [Schematron](StructureDefinition-nl-gf-location.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-location",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile",
      "valueCanonical" : "https://profiles.ihe.net/ITI/mCSD/StructureDefinition/IHE.mCSD.Location"
    }
  ],
  "url" : "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-location",
  "version" : "0.1.0",
  "name" : "NlGfLocation",
  "title" : "NL Generic Functions Location Profile",
  "status" : "draft",
  "date" : "2026-02-17T17:25:51+00:00",
  "publisher" : "Ministerie van Volksgezondheid, Welzijn en Sport",
  "contact" : [
    {
      "name" : "Ministerie van Volksgezondheid, Welzijn en Sport",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.minvws.nl"
        }
      ]
    }
  ],
  "description" : "Physical location details for healthcare services, organizations, and practitioners.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "zib-healthcareprovider-v3.4-2020EN",
      "uri" : "https://zibs.nl/wiki/HealthcareProvider-v3.4(2020EN)",
      "name" : "zib HealthcareProvider-v3.4(2020EN)"
    },
    {
      "identity" : "zib-contactinformation-v1.2-2020EN",
      "uri" : "https://zibs.nl/wiki/ContactInformation-v1.2(2020EN)",
      "name" : "zib ContactInformation-v1.2(2020EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Location",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/nl-core-HealthcareProvider",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Location",
        "path" : "Location"
      },
      {
        "id" : "Location.implicitRules",
        "path" : "Location.implicitRules",
        "max" : "0"
      },
      {
        "id" : "Location.modifierExtension",
        "path" : "Location.modifierExtension",
        "max" : "0"
      },
      {
        "id" : "Location.identifier",
        "path" : "Location.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Location.identifier:AssignedId",
        "path" : "Location.identifier",
        "sliceName" : "AssignedId",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-authorassignedidentifier"
            ]
          }
        ]
      },
      {
        "id" : "Location.status",
        "path" : "Location.status",
        "min" : 1
      },
      {
        "id" : "Location.name",
        "path" : "Location.name",
        "min" : 1
      },
      {
        "id" : "Location.type",
        "path" : "Location.type",
        "min" : 1
      },
      {
        "id" : "Location.managingOrganization",
        "path" : "Location.managingOrganization",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-organization"
            ]
          }
        ]
      }
    ]
  }
}

```
