# NL Generic Functions Localization List Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions Localization List Profile**

## Resource Profile: NL Generic Functions Localization List Profile 

| | |
| :--- | :--- |
| *Official URL*:http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-localization-list | *Version*:0.1.0 |
| Draft as of 2026-02-17 | *Computable Name*:NlGfLocalizationList |

 
A List profile for registering the availability of patient data at healthcare organizations for localization services. This profile is used to indicate that certain patient data is available at a specific organization and can be accessed for localization purposes. 

**Usages:**

* CapabilityStatements using this Profile: [Localization Service (List)](CapabilityStatement-nl-gf-localization-repository-list.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.gf|current/StructureDefinition/nl-gf-localization-list)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-localization-list.csv), [Excel](StructureDefinition-nl-gf-localization-list.xlsx), [Schematron](StructureDefinition-nl-gf-localization-list.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-localization-list",
  "url" : "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-localization-list",
  "version" : "0.1.0",
  "name" : "NlGfLocalizationList",
  "title" : "NL Generic Functions Localization List Profile",
  "status" : "draft",
  "date" : "2026-02-17T17:25:51+00:00",
  "publisher" : "Ministerie van Volksgezondheid, Welzijn en Sport",
  "contact" : [
    {
      "name" : "Ministerie van Volksgezondheid, Welzijn en Sport",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.minvws.nl"
        }
      ]
    }
  ],
  "description" : "A List profile for registering the availability of patient data\nat healthcare organizations for localization services. This profile is used to\nindicate that certain patient data is available at a specific organization and\ncan be accessed for localization purposes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "List",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/List",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "List",
        "path" : "List"
      },
      {
        "id" : "List.meta",
        "path" : "List.meta",
        "max" : "0"
      },
      {
        "id" : "List.implicitRules",
        "path" : "List.implicitRules",
        "max" : "0"
      },
      {
        "id" : "List.language",
        "path" : "List.language",
        "max" : "0"
      },
      {
        "id" : "List.text",
        "path" : "List.text",
        "max" : "0"
      },
      {
        "id" : "List.contained",
        "path" : "List.contained",
        "max" : "0"
      },
      {
        "id" : "List.extension",
        "path" : "List.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "List.extension:custodian",
        "path" : "List.extension",
        "sliceName" : "custodian",
        "comment" : "The Organization which published the data",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-localization-custodian"
            ]
          }
        ]
      },
      {
        "id" : "List.identifier",
        "path" : "List.identifier",
        "max" : "0"
      },
      {
        "id" : "List.status",
        "path" : "List.status",
        "comment" : "All records are always current",
        "patternCode" : "current"
      },
      {
        "id" : "List.mode",
        "path" : "List.mode",
        "patternCode" : "working"
      },
      {
        "id" : "List.title",
        "path" : "List.title",
        "max" : "0"
      },
      {
        "id" : "List.code",
        "path" : "List.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://minvws.github.io/generiekefuncties-docs/ValueSet/nl-gf-zorgcontext-vs"
        }
      },
      {
        "id" : "List.subject",
        "path" : "List.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Patient"]
          }
        ]
      },
      {
        "id" : "List.subject.reference",
        "path" : "List.subject.reference",
        "max" : "0"
      },
      {
        "id" : "List.subject.identifier",
        "path" : "List.subject.identifier",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-pseudo-bsn-identifier"
            ]
          }
        ]
      },
      {
        "id" : "List.source",
        "path" : "List.source",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Device"]
          }
        ]
      },
      {
        "id" : "List.source.reference",
        "path" : "List.source.reference",
        "max" : "0"
      },
      {
        "id" : "List.source.type",
        "path" : "List.source.type",
        "patternUri" : "Device"
      },
      {
        "id" : "List.note",
        "path" : "List.note",
        "max" : "0"
      },
      {
        "id" : "List.entry",
        "path" : "List.entry",
        "max" : "0"
      },
      {
        "id" : "List.emptyReason",
        "path" : "List.emptyReason",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/list-empty-reason",
              "code" : "withheld"
            }
          ]
        }
      }
    ]
  }
}

```
